package com.atlassian.support.tools.salext.bundle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.support.tools.salext.SupportApplicationInfo;

/** 
 * This class is for getting the directory configuration summary out of instances that are pre-Crowd-2.6.2. 
 * It is designed to be replaced by AuthenticationConfigurationSummary.jaa in future.
 * @author denise
 *
 */
public class LegacyAuthenticationConfigurationFileBundle extends AbstractApplicationFileBundle
{
    private static final Logger log = Logger.getLogger(LegacyAuthenticationConfigurationFileBundle.class);
    
    private final Map<String, String> files;
    private final CrowdDirectoryService dirService;
    private final SupportApplicationInfo info;
    
    public LegacyAuthenticationConfigurationFileBundle(BundleManifest bundle, String title, String description, SupportApplicationInfo info, CrowdDirectoryService dirService, String... files)
    {
        super(bundle, title, description);
        this.dirService = dirService;
        this.info = info;
		this.files = new HashMap<String, String>();
		
		for (String file : files)
		{
			this.files.put(file, "");
		}
    }

    @Override
    public Map<String, String> getFiles()
    {
        // Create export directory
        final File supportDir = new File(info.getApplicationHome(), "logs/support");
        
        if( ! supportDir.exists() && ! supportDir.mkdirs())
        {
            log.error("Couldn't create export directory " + supportDir.getAbsolutePath());
            return null; 
        }

        // Process directories
        final File dirConfigFile = new File(supportDir,"directoryConfigurationSummary.txt");
        try
        {
            final FileWriter configWriter = new FileWriter(dirConfigFile);
            try
            {
            	final StringBuilder configString = new StringBuilder();
            	
            	// Get all directories
            	final List<Directory> dirs = dirService.findAllDirectories();
            	
                if (dirs.isEmpty())
                {
                    configString.append("No directories, or something has gone wrong.");
                }
            	
            	for (Directory dir : dirs)
            	{
                    configString.append(dir.getName() + "\n=============================\n");
            		
            		for (Entry<String, String> attribute : dir.getAttributes().entrySet())
            		{
            			configString.append((String) attribute.getKey());
            			configString.append(": ");
            			configString.append((String) attribute.getValue());
            			configString.append("\n");
            		}
            		configString.append("\n\n");
            	}
            
                configWriter.write(configString.toString());
            }
            catch(IOException e)
            {
                log.error("Failed to write directory configuration to "+dirConfigFile.getPath()+".", e);
            }
            finally
            {
                configWriter.flush();
                configWriter.close();
            }
            
            // Add the list of directories to the zip
            files.put(dirConfigFile.getAbsolutePath(), "");
        }
        catch(Exception e)
        {
            log.error("Can't generate directory configuration file.", e);
        }
        
        return files;
    }
}