package com.atlassian.support.tools.properties.appenders;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.support.tools.spi.RootLevelSupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;

import static com.atlassian.support.tools.salext.SupportApplicationInfo.*;

/**
 * Adds information about the product's configured application links.
 */
public class ApplicationLinksInfoAppender extends RootLevelSupportInfoAppender
{
    private final ApplicationLinkService linkService;

    public ApplicationLinksInfoAppender(ApplicationLinkService linkService)
    {
        this.linkService = linkService;
    }

    @Override
    protected void addSupportInfo(SupportInfoBuilder builder)
    {
        addApplicationLinkInformation(builder.addCategory(LINK));
    }

    private void addApplicationLinkInformation(SupportInfoBuilder builder)
    {
        for (ApplicationLink link : linkService.getApplicationLinks())
        {
            SupportInfoBuilder linkBuilder = builder.addCategory(LINK);
            linkBuilder.addValue(LINK_NAME, link.getName());
            linkBuilder.addValue(LINK_PRIMARY, String.valueOf(link.isPrimary()));
            linkBuilder.addValue(LINK_TYPE, link.getType().getI18nKey());
            linkBuilder.addValue(LINK_DISPLAY_URL, link.getDisplayUrl().toString());
            linkBuilder.addValue(LINK_RPC_URL, link.getRpcUrl().toString());
            linkBuilder.addContext(link);
        }
    }

}
