package com.atlassian.support.tools.hercules;

import org.apache.commons.lang.StringUtils;

public class HerculesTools {
	public static String getInstrumentedURL(String url, String medium)
	{
		return getInstrumentedURL(url, medium, null);
	}
	
	public static String getInstrumentedURL(String url, String medium, String content)
	{
		if(StringUtils.isBlank(url) || StringUtils.isBlank(medium))
			return url;
		
		url = url.trim();
		url += (url.indexOf('?') == -1) ? '?' : '&';
		url += "utm_source=STP";
		url += "&utm_medium="+medium;
		if (content != null) {
			url+= "&utm_content="+content;
		}
		return url;
	}
}
