/*
 * Decompiled with CFR 0.152.
 */
package net.admin4j.ui.servlets;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.admin4j.config.HackedAdmin4JConfiguration;
import net.admin4j.ui.servlets.FileExplorerServlet;

public class AchooHomeDir
extends FileExplorerServlet {
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;

    public AchooHomeDir(ApplicationProperties applicationProperties, UserManager userManager) {
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
    }

    public void init(final ServletConfig config) throws ServletException {
        String home = this.applicationProperties.getHomeDirectory().getAbsolutePath();
        HackedAdmin4JConfiguration.updateBaseDir(home);
        ServletConfig homeConfig = new ServletConfig(){

            public String getServletName() {
                return config.getServletName();
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            public String getInitParameter(String s) {
                return s.contains("base.dir.name") ? null : config.getInitParameter(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return config.getInitParameterNames();
            }
        };
        super.init(homeConfig);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (userKey != null && this.userManager.isSystemAdmin(userKey)) {
            super.service(request, response);
        } else {
            try {
                response.sendError(403, "Only a system administrator can access this resource");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

