/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.thirdparty.api;

import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.thirdparty.api.ActivityObject;
import com.atlassian.streams.thirdparty.api.Application;
import com.atlassian.streams.thirdparty.api.Image;
import com.atlassian.streams.thirdparty.api.ValidationErrors;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.joda.time.DateTime;

public class Activity {
    private final Option<Long> activityId;
    private final Option<Html> content;
    private final Application application;
    private final Option<Image> icon;
    private final Option<URI> id;
    private final Option<ActivityObject> object;
    private final DateTime postedDate;
    private final Option<String> poster;
    private final boolean registeredUser;
    private final Option<ActivityObject> target;
    private final Option<Html> title;
    private final Option<URI> url;
    private final UserProfile user;
    private final Option<URI> verb;

    public static Builder builder(Application application, DateTime postedDate, UserProfile user) {
        return new Builder(application, postedDate, user);
    }

    public static Builder builder(Application application, DateTime postedDate, String username) {
        return new Builder(application, postedDate, new UserProfile.Builder(username).build());
    }

    private Activity(Builder builder) {
        this.activityId = builder.activityId;
        this.content = builder.content;
        this.application = builder.application;
        this.icon = builder.icon;
        this.id = builder.id;
        this.object = builder.object;
        this.postedDate = builder.postedDate;
        this.poster = builder.poster;
        this.registeredUser = builder.registeredUser;
        this.target = builder.target;
        this.title = builder.title;
        this.url = builder.url;
        this.user = builder.user;
        this.verb = builder.verb;
    }

    public Option<Long> getActivityId() {
        return this.activityId;
    }

    public Application getApplication() {
        return this.application;
    }

    public Option<Html> getContent() {
        return this.content;
    }

    public Option<Image> getIcon() {
        return this.icon;
    }

    public Option<URI> getId() {
        return this.id;
    }

    public Option<ActivityObject> getObject() {
        return this.object;
    }

    public DateTime getPostedDate() {
        return this.postedDate;
    }

    public Option<String> getPoster() {
        return this.poster;
    }

    public boolean isRegisteredUser() {
        return this.registeredUser;
    }

    public Option<ActivityObject> getTarget() {
        return this.target;
    }

    public Option<Html> getTitle() {
        return this.title;
    }

    public Option<URI> getUrl() {
        return this.url;
    }

    public UserProfile getUser() {
        return this.user;
    }

    public Option<URI> getVerb() {
        return this.verb;
    }

    public boolean equals(Object other) {
        if (other instanceof Activity) {
            Activity a = (Activity)other;
            return this.activityId.equals(a.activityId) && this.application.equals(a.application) && this.content.equals(a.content) && this.icon.equals(a.icon) && this.id.equals(a.id) && this.object.equals(a.object) && this.postedDate.equals((Object)a.postedDate) && this.poster.equals(a.poster) && this.registeredUser == a.registeredUser && this.target.equals(a.target) && this.title.equals(a.title) && this.url.equals(a.url) && this.user.equals((Object)a.user) && this.verb.equals(a.verb);
        }
        return false;
    }

    public int hashCode() {
        return this.activityId.hashCode() + 37 * (this.application.hashCode() + 37 * (this.content.hashCode() + 37 * (this.icon.hashCode() + 37 * (this.id.hashCode() + 37 * (this.object.hashCode() + 37 * (this.postedDate.hashCode() + 37 * (this.poster.hashCode() + 37 * ((this.registeredUser ? 1 : 0) + 37 * (this.target.hashCode() + 37 * (this.title.hashCode() + 37 * (this.url.hashCode() + 37 * (this.user.hashCode() + 37 * this.verb.hashCode()))))))))))));
    }

    public static final class Builder {
        private ValidationErrors.Builder errors = new ValidationErrors.Builder();
        private Option<Long> activityId = Option.none();
        private Option<Html> content = Option.none();
        private final Application application;
        private Option<Image> icon = Option.none();
        private Option<URI> id = Option.none();
        private Option<ActivityObject> object = Option.none();
        private final DateTime postedDate;
        private Option<String> poster = Option.none();
        private boolean registeredUser = false;
        private Option<ActivityObject> target = Option.none();
        private Option<Html> title = Option.none();
        private Option<URI> url = Option.none();
        private final UserProfile user;
        private Option<URI> verb = Option.none();

        public Builder(Application application, DateTime postedDate, UserProfile user) {
            this((Either<ValidationErrors, Application>)Either.right((Object)application), (Either<ValidationErrors, DateTime>)Either.right((Object)postedDate), (Either<ValidationErrors, UserProfile>)Either.right((Object)user));
        }

        public Builder(Either<ValidationErrors, Application> application, Either<ValidationErrors, DateTime> postedDate, Either<ValidationErrors, UserProfile> user) {
            if (application.isRight()) {
                this.application = (Application)application.right().get();
            } else {
                this.errors.addAll((ValidationErrors)application.left().get(), "application");
                this.application = null;
            }
            if (postedDate.isRight()) {
                this.postedDate = (DateTime)postedDate.right().get();
            } else {
                this.errors.addAll((ValidationErrors)postedDate.left().get(), "postedDate");
                this.postedDate = null;
            }
            if (user.isRight()) {
                this.user = (UserProfile)user.right().get();
                this.errors.checkString(this.user.getUsername(), "user.username");
                this.errors.checkString(this.user.getFullName(), "user.fullName");
                this.errors.checkAbsoluteUri((Option<URI>)this.user.getProfilePageUri(), "user.profilePageUri");
                this.errors.checkAbsoluteUri((Option<URI>)this.user.getProfilePictureUri(), "user.profilePictureUri");
            } else {
                this.errors.addAll((ValidationErrors)user.left().get(), "user");
                this.user = null;
            }
        }

        public Either<ValidationErrors, Activity> build() {
            if (!this.id.isDefined() && !this.url.isDefined()) {
                this.errors.addError("activity id and url cannot both be omitted");
            }
            if (this.errors.isEmpty()) {
                return Either.right((Object)new Activity(this));
            }
            return Either.left((Object)this.errors.build());
        }

        public Builder activityId(long activityId) {
            this.activityId = Option.some((Object)activityId);
            return this;
        }

        public Builder content(Option<Html> content) {
            this.content = this.errors.checkHtml(content, "content", 5000);
            return this;
        }

        public Builder icon(Option<Image> icon) {
            this.icon = (Option)Preconditions.checkNotNull(icon, (Object)"icon");
            return this;
        }

        public Builder icon(Either<ValidationErrors, Image> imageOrErrors) {
            Preconditions.checkNotNull(imageOrErrors, (Object)"imageOrErrors");
            if (imageOrErrors.isRight()) {
                this.icon = imageOrErrors.right().toOption();
            } else {
                this.errors.addAll((ValidationErrors)imageOrErrors.left().get(), "icon");
            }
            return this;
        }

        public Builder id(Option<URI> id) {
            this.id = this.errors.checkAbsoluteUri(id, "id");
            return this;
        }

        public Builder idString(Option<String> id) {
            this.id = this.errors.checkAbsoluteUriString(id, "id");
            return this;
        }

        public Builder object(Option<ActivityObject> object) {
            this.object = (Option)Preconditions.checkNotNull(object, (Object)"object");
            return this;
        }

        public Builder object(Either<ValidationErrors, ActivityObject> objectOrErrors) {
            Preconditions.checkNotNull(objectOrErrors, (Object)"targetOrErrors");
            if (objectOrErrors.isRight()) {
                this.object = objectOrErrors.right().toOption();
            } else {
                this.errors.addAll((ValidationErrors)objectOrErrors.left().get(), "object");
            }
            return this;
        }

        public Builder poster(Option<String> poster) {
            this.poster = this.errors.checkString(poster, "poster");
            return this;
        }

        public Builder registeredUser(boolean registeredUser) {
            this.registeredUser = registeredUser;
            return this;
        }

        public Builder target(Option<ActivityObject> target) {
            this.target = (Option)Preconditions.checkNotNull(target, (Object)"target");
            return this;
        }

        public Builder target(Either<ValidationErrors, ActivityObject> targetOrErrors) {
            Preconditions.checkNotNull(targetOrErrors, (Object)"targetOrErrors");
            if (targetOrErrors.isRight()) {
                this.target = targetOrErrors.right().toOption();
            } else {
                this.errors.addAll((ValidationErrors)targetOrErrors.left().get(), "target");
            }
            return this;
        }

        public Builder title(Option<Html> title) {
            this.title = this.errors.checkHtml(title, "title", 255);
            return this;
        }

        public Builder url(Option<URI> url) {
            this.url = this.errors.checkAbsoluteUri(url, "url");
            return this;
        }

        public Builder urlString(Option<String> url) {
            this.url = this.errors.checkAbsoluteUriString(url, "url");
            return this;
        }

        public Builder verb(Option<URI> verb) {
            this.verb = this.errors.checkSimpleNameOrAbsoluteUri(verb, "verb");
            return this;
        }

        public Builder verbString(Option<String> verb) {
            this.verb = this.errors.checkSimpleNameOrAbsoluteUriString(verb, "verb");
            return this;
        }
    }
}

