/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.spi;

import com.atlassian.annotations.PublicApi;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.api.common.Option;
import com.google.common.base.Preconditions;
import java.net.URI;

@PublicApi
public interface StreamsCommentHandler {
    public Either<PostReplyError, URI> postReply(Iterable<String> var1, String var2);

    public Either<PostReplyError, URI> postReply(URI var1, Iterable<String> var2, String var3);

    public static class PostReplyError {
        final Type type;
        final Option<Throwable> cause;

        public PostReplyError(Type type) {
            this(type, null);
        }

        public PostReplyError(Type type, Throwable cause) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
            this.cause = Option.option((Object)cause);
        }

        public Type getType() {
            return this.type;
        }

        public Option<Throwable> getCause() {
            return this.cause;
        }

        public static enum Type {
            DELETED_OR_PERMISSION_DENIED(404, "comment.deleted.or.denied"),
            UNAUTHORIZED(401, "unauthorized"),
            FORBIDDEN(403, "forbidden"),
            CONFLICT(409, "conflict"),
            REMOTE_POST_REPLY_ERROR(500, "remote.error"),
            UNKNOWN_ERROR(500, "unknown.error");

            private final int statusCode;
            private final String subCode;

            private Type(int statusCode, String subCode) {
                this.statusCode = statusCode;
                this.subCode = "streams.comment.action." + subCode;
            }

            public int getStatusCode() {
                return this.statusCode;
            }

            public String getSubCode() {
                return this.subCode;
            }

            public String asJsonString() {
                return "{\"subCode\" : \"" + this.subCode + "\"}";
            }
        }
    }
}

