/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.uri.Uris;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.spi.ServletPath;
import com.atlassian.streams.spi.StreamsUriBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraEntryBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraEntryBuilderFactory.class);
    public static final String JIRA_APPLICATION_TYPE = "com.atlassian.jira";
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final WatcherManager watcherManager;
    private final VoteManager voteManager;
    private final UriProvider uriProvider;

    JiraEntryBuilderFactory(ApplicationProperties applicationProperties, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, WatcherManager watcherManager, VoteManager voteManager, UriProvider uriProvider) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.watcherManager = (WatcherManager)Preconditions.checkNotNull((Object)watcherManager, (Object)"watcherManager");
        this.voteManager = (VoteManager)Preconditions.checkNotNull((Object)voteManager, (Object)"voteManager");
        this.uriProvider = (UriProvider)Preconditions.checkNotNull((Object)uriProvider, (Object)"uriProvider");
    }

    public StreamsEntry.Parameters<StreamsEntry.HasId, StreamsEntry.HasPostedDate, StreamsEntry.HasAlternateLinkUri, StreamsEntry.HasApplicationType, StreamsEntry.NeedsRenderer, StreamsEntry.NeedsVerb, StreamsEntry.NeedsAuthors> newParams(JiraActivityItem item, URI itemUri, URI baseUri) {
        return this.newParams(item, itemUri, baseUri, false);
    }

    public StreamsEntry.Parameters<StreamsEntry.HasId, StreamsEntry.HasPostedDate, StreamsEntry.HasAlternateLinkUri, StreamsEntry.HasApplicationType, StreamsEntry.NeedsRenderer, StreamsEntry.NeedsVerb, StreamsEntry.NeedsAuthors> newLinkedIssueParams(JiraActivityItem item, URI itemUri, URI baseUri) {
        return this.newParams(item, itemUri, baseUri, true);
    }

    private StreamsEntry.Parameters<StreamsEntry.HasId, StreamsEntry.HasPostedDate, StreamsEntry.HasAlternateLinkUri, StreamsEntry.HasApplicationType, StreamsEntry.NeedsRenderer, StreamsEntry.NeedsVerb, StreamsEntry.NeedsAuthors> newParams(JiraActivityItem item, URI itemUri, URI baseUri, boolean issueLinked) {
        StreamsUriBuilder uriBuilder = new StreamsUriBuilder().setUrl(itemUri.toASCIIString());
        if (item.getChangeHistory().isDefined() || item.getComment().isDefined()) {
            uriBuilder.setTimestamp(item.getDate());
        }
        return StreamsEntry.params().id(uriBuilder.getUri()).postedDate(new DateTime((Object)item.getDate())).applicationType(JIRA_APPLICATION_TYPE).alternateLinkUri(itemUri).baseUri(baseUri).addLinks(this.buildLinks(item, issueLinked));
    }

    private Iterable<StreamsEntry.Link> buildLinks(JiraActivityItem item, boolean issueLinked) {
        Issue issue = item.getIssue();
        ImmutableList.Builder links = ImmutableList.builder();
        links.add((Object)this.getIconLink(this.applicationProperties.getBaseUrl(), issue));
        links.add((Object)new StreamsEntry.Link(this.uriProvider.getWikiRendererCssUri(), "http://streams.atlassian.com/syndication/css", Option.none(String.class)));
        if (!issueLinked) {
            if (this.permissionManager.hasPermission(15, issue, this.authenticationContext.getLoggedInUser())) {
                links.add((Object)new StreamsEntry.Link(this.getReplyToUri(issue.getKey()), "http://streams.atlassian.com/syndication/reply-to", Option.none(String.class)));
            }
            if (this.isUserLoggedIn()) {
                if (this.canWatch(issue)) {
                    links.add((Object)new StreamsEntry.Link(this.getIssueWatchUri(issue.getKey()), "http://streams.atlassian.com/syndication/watch", Option.none(String.class)));
                }
                if (this.canVote(item)) {
                    links.add((Object)new StreamsEntry.Link(this.getIssueVoteUri(issue.getKey()), "http://streams.atlassian.com/syndication/issue-vote", Option.none(String.class)));
                }
            }
        }
        return links.build();
    }

    private boolean canWatch(Issue issue) {
        try {
            return this.watcherManager.isWatchingEnabled() && !this.watcherManager.isWatching(this.authenticationContext.getLoggedInUser(), issue);
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error checking if current user is watching " + issue.getKey(), (Throwable)e);
            }
            return false;
        }
    }

    private boolean canVote(JiraActivityItem item) {
        Issue issue = item.getIssue();
        try {
            return this.voteManager.isVotingEnabled() && !this.voteManager.hasVoted(this.authenticationContext.getUser(), issue) && issue.getResolution() == null && !issue.getReporterId().equals(this.authenticationContext.getUser().getKey()) && !((ActivityObjectType)item.getActivity().first()).equals(ActivityObjectTypes.comment());
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error checking if current user can vote on " + issue.getKey(), (Throwable)e);
            }
            return false;
        }
    }

    private boolean isUserLoggedIn() {
        return this.authenticationContext.getLoggedInUser() != null;
    }

    private URI getReplyToUri(String key) {
        return URI.create(this.applicationProperties.getBaseUrl() + ServletPath.COMMENTS + "/" + Uris.encode((String)"issues") + "/" + Uris.encode((String)key)).normalize();
    }

    private URI getIssueWatchUri(String key) {
        return URI.create(this.applicationProperties.getBaseUrl() + "/rest/jira-activity-stream/1.0/actions/issue-watch/" + Uris.encode((String)key)).normalize();
    }

    private URI getIssueVoteUri(String key) {
        return URI.create(this.applicationProperties.getBaseUrl() + "/rest/jira-activity-stream/1.0/actions/issue-vote/" + Uris.encode((String)key)).normalize();
    }

    private StreamsEntry.Link getIconLink(String baseUrl, Issue issue) {
        URI uri = URI.create(issue.getIssueTypeObject().getIconUrl());
        IssueType issueType = issue.getIssueTypeObject();
        if (!uri.isAbsolute()) {
            uri = URI.create(baseUrl + issue.getIssueTypeObject().getIconUrl());
        }
        return new StreamsEntry.Link(uri, "http://streams.atlassian.com/syndication/icon", Option.some((Object)issueType.getNameTranslation()));
    }
}

