/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.renderer.AttachmentRendererFactory;
import com.atlassian.streams.jira.renderer.IssueUpdateRendererFactory;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.ofbiz.core.entity.GenericValue;

class GeneralUpdateEntryBuilder {
    private final JiraHelper helper;
    private final AttachmentRendererFactory attachmentRendererFactory;
    private final IssueUpdateRendererFactory issueUpdateRendererFactory;
    private final StreamsI18nResolver i18nResolver;

    GeneralUpdateEntryBuilder(JiraHelper helper, AttachmentRendererFactory attachmentRendererFactory, IssueUpdateRendererFactory issueUpdateRendererFactory, StreamsI18nResolver i18nResolver) {
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.attachmentRendererFactory = (AttachmentRendererFactory)Preconditions.checkNotNull((Object)attachmentRendererFactory, (Object)"attachmentRendererFactory");
        this.issueUpdateRendererFactory = (IssueUpdateRendererFactory)Preconditions.checkNotNull((Object)issueUpdateRendererFactory, (Object)"issueUpdateRendererFactory");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    Option<StreamsEntry> build(URI baseUri, AggregatedJiraActivityItem aggregatedItem) {
        if (aggregatedItem.getRelatedActivityItems().isDefined()) {
            return this.buildMultipleActivityItem(baseUri, aggregatedItem);
        }
        return this.buildSingleActivityItem(baseUri, aggregatedItem.getActivityItem());
    }

    private Option<StreamsEntry> buildSingleActivityItem(URI baseUri, JiraActivityItem item) {
        Iterable changeItems = Iterables.filter(ChangeItems.getChangeItems(item), this.helper.validAttachment());
        if (Iterables.isEmpty((Iterable)changeItems)) {
            return Option.none();
        }
        if (Pair.pair((Object)ActivityObjectTypes.file(), (Object)ActivityVerbs.post()).equals(item.getActivity())) {
            return this.buildAttachments(item, baseUri, changeItems);
        }
        if (Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.remoteLink()).equals(item.getActivity())) {
            return this.buildRemoteLink(item, baseUri, changeItems);
        }
        return Option.some((Object)new StreamsEntry((item.getComment().isDefined() ? this.helper.newCommentBuilder(baseUri, item) : this.helper.newBuilder(item, baseUri)).authors(this.helper.getUserProfiles(baseUri, item.getChangeHistoryAuthors())).addActivityObject(this.helper.buildActivityObject(item.getIssue(), baseUri, item.getDisplaySummary())).verb(ActivityVerbs.update()).renderer(this.issueUpdateRendererFactory.newRenderer(item, baseUri, changeItems)), (I18nResolver)this.i18nResolver));
    }

    private Option<StreamsEntry> buildMultipleActivityItem(URI baseUri, AggregatedJiraActivityItem aggregatedItem) {
        if (Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.link()).equals(aggregatedItem.getActivity())) {
            JiraActivityItem mainItem = aggregatedItem.getActivityItem();
            return Option.some((Object)new StreamsEntry(this.helper.newLinkedIssueBuilder(baseUri, mainItem).authors(this.helper.getUserProfiles(baseUri, mainItem.getChangeHistoryAuthors())).addActivityObject(this.helper.buildActivityObject(mainItem.getIssue(), baseUri, mainItem.getDisplaySummary())).verb(ActivityVerbs.update()).renderer(this.issueUpdateRendererFactory.newIssueLinkEntryRenderer(baseUri, aggregatedItem)), (I18nResolver)this.i18nResolver));
        }
        return Option.none();
    }

    private Option<StreamsEntry> buildAttachments(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
        Iterable<Attachment> attachments = this.helper.extractAttachments(changeItems);
        if (!Iterables.isEmpty(attachments)) {
            return Option.some((Object)new StreamsEntry(this.helper.newBuilder(item, baseUri).authors(this.helper.getUserProfiles(baseUri, item.getChangeHistoryAuthors())).verb(ActivityVerbs.post()).addActivityObjects(this.helper.buildActivityObjects(baseUri, attachments)).target(Option.some((Object)this.helper.buildActivityObject(item.getIssue(), baseUri, item.getDisplaySummary()))).renderer(this.attachmentRendererFactory.newAttachmentsEntryRenderer(item, baseUri, attachments)), (I18nResolver)this.i18nResolver));
        }
        return Option.none();
    }

    private Option<StreamsEntry> buildRemoteLink(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
        Option<RemoteIssueLink> remoteLink = this.helper.extractRemoteIssueLink(changeItems);
        if (remoteLink.isDefined()) {
            return Option.some((Object)new StreamsEntry(this.helper.newBuilder(item, baseUri).authors(this.helper.getUserProfiles(baseUri, item.getChangeHistoryAuthors())).addActivityObject(this.helper.buildActivityObject(item.getIssue(), baseUri, item.getDisplaySummary())).verb(ActivityVerbs.update()).renderer(this.issueUpdateRendererFactory.newRemoteIssueLinkEntryRenderer(baseUri, item, (RemoteIssueLink)remoteLink.get())), (I18nResolver)this.i18nResolver));
        }
        return Option.none();
    }
}

