/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.Issue;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.ImmutableNonEmptyList;
import com.atlassian.streams.api.common.NonEmptyIterable;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.renderer.CreatedIssueRendererFactory;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;

public class CreatedEntryBuilder {
    private static final String CREATED_CATEGORY = "created";
    private final JiraHelper helper;
    private final CreatedIssueRendererFactory rendererFactory;
    private final StreamsI18nResolver i18nResolver;

    CreatedEntryBuilder(JiraHelper helper, CreatedIssueRendererFactory rendererFactory, StreamsI18nResolver i18nResolver) {
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.rendererFactory = (CreatedIssueRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    public Option<StreamsEntry> build(JiraActivityItem item, ActivityRequest request) {
        Issue issue = item.getIssue();
        URI baseUri = request.getContextUri();
        return Option.some((Object)new StreamsEntry(this.helper.newBuilder(item, baseUri).authors((NonEmptyIterable)ImmutableNonEmptyList.of((Object)this.helper.getUserProfile(baseUri).apply((Object)JiraHelper.getNameFor(issue.getReporterUser())))).categories((Iterable)ImmutableList.of((Object)CREATED_CATEGORY)).addActivityObject(this.helper.buildActivityObject(issue, baseUri, item.getDisplaySummary())).verb(ActivityVerbs.post()).renderer(this.rendererFactory.newInstance(item.getIssue(), baseUri, item.getInitialDescription())), (I18nResolver)this.i18nResolver));
    }
}

