/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.spi.StreamsCommentHandler;
import com.google.common.collect.Iterables;
import java.net.URI;

public class JiraStreamsCommentHandler
implements StreamsCommentHandler {
    private final JiraAuthenticationContext authenticationContext;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final CommentService commentService;
    private final ApplicationProperties applicationProperties;

    public JiraStreamsCommentHandler(JiraAuthenticationContext authenticationContext, IssueManager issueManager, PermissionManager permissionManager, CommentService commentService, ApplicationProperties applicationProperties) {
        this.authenticationContext = authenticationContext;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.commentService = commentService;
        this.applicationProperties = applicationProperties;
    }

    public Either<StreamsCommentHandler.PostReplyError, URI> postReply(URI baseUri, Iterable<String> itemPath, String comment) throws StreamsException {
        User user = this.authenticationContext.getLoggedInUser();
        String issueKey = (String)Iterables.getOnlyElement(itemPath);
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null) {
            return Either.left((Object)new StreamsCommentHandler.PostReplyError(StreamsCommentHandler.PostReplyError.Type.DELETED_OR_PERMISSION_DENIED));
        }
        if (!this.permissionManager.hasPermission(15, (Issue)issue, user)) {
            return Either.left((Object)new StreamsCommentHandler.PostReplyError(StreamsCommentHandler.PostReplyError.Type.UNAUTHORIZED));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Comment commentObject = this.commentService.create(user, (Issue)issue, comment, true, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)new StreamsCommentHandler.PostReplyError(StreamsCommentHandler.PostReplyError.Type.UNKNOWN_ERROR));
        }
        return Either.right((Object)URI.create(baseUri.toASCIIString() + "/browse/" + issueKey + "#action_" + commentObject.getId()));
    }

    public Either<StreamsCommentHandler.PostReplyError, URI> postReply(Iterable<String> itemPath, String comment) {
        return this.postReply(URI.create(this.applicationProperties.getBaseUrl()), itemPath, comment);
    }
}

