/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.streams.jira.JiraInlineActionHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

public class JiraInlineActionHandlerImpl
implements JiraInlineActionHandler {
    private final WatcherManager watcherManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VoteManager voteManager;

    public JiraInlineActionHandlerImpl(WatcherManager watcherManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext, VoteManager voteManager) {
        this.watcherManager = (WatcherManager)Preconditions.checkNotNull((Object)watcherManager, (Object)"watcherManager");
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager, (Object)"issueManager");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.voteManager = (VoteManager)Preconditions.checkNotNull((Object)voteManager, (Object)"voteManager");
    }

    @Override
    public boolean startWatching(String issueKey) {
        User user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        int previousWatcherCount = Iterables.size((Iterable)this.watcherManager.getCurrentWatcherUsernames(issue.getGenericValue()));
        this.watcherManager.startWatching(user, issue.getGenericValue());
        int updatedWatcherCount = Iterables.size((Iterable)this.watcherManager.getCurrentWatcherUsernames(issue.getGenericValue()));
        return updatedWatcherCount == previousWatcherCount + 1;
    }

    @Override
    public boolean hasPreviouslyWatched(String issueKey) {
        User user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return this.watcherManager.isWatching(user, (Issue)issue);
    }

    @Override
    public boolean voteOnIssue(String issueKey) {
        User user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return this.voteManager.addVote(user, issue.getGenericValue());
    }

    @Override
    public boolean hasPreviouslyVoted(String issueKey) {
        User user = this.authenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return this.voteManager.hasVoted(user, (Issue)issue);
    }
}

