/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.spi.EntityIdentifier;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.atlassian.streams.spi.StreamsEntityAssociationProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class JiraEntityAssociationProvider
implements StreamsEntityAssociationProvider {
    private static final Pattern PATTERN = Pattern.compile("([^-\\?#]+)(-?[^\\?#]*)(.*)");
    private static final String BROWSE = "/browse/";
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;

    public JiraEntityAssociationProvider(ApplicationProperties applicationProperties, PermissionManager permissionManager, ProjectManager projectManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager, (Object)"projectManager");
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager, (Object)"issueManager");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
    }

    public Iterable<EntityIdentifier> getEntityIdentifiers(URI target) {
        String targetStr = target.toString();
        if (target.isAbsolute()) {
            if (!targetStr.startsWith(this.applicationProperties.getBaseUrl() + BROWSE)) {
                return ImmutableList.of();
            }
            String suffix = targetStr.substring(this.applicationProperties.getBaseUrl().length() + BROWSE.length());
            return this.matchEntities(suffix);
        }
        return this.matchEntities(targetStr);
    }

    public Option<URI> getEntityURI(EntityIdentifier identifier) {
        if (identifier.getType().equals(JiraActivityObjectTypes.project().iri()) || identifier.getType().equals(JiraActivityObjectTypes.issue().iri())) {
            return Option.some((Object)URI.create(this.applicationProperties.getBaseUrl() + BROWSE + identifier.getValue()));
        }
        return Option.none();
    }

    public Option<String> getFilterKey(EntityIdentifier identifier) {
        if (identifier.getType().equals(JiraActivityObjectTypes.project().iri())) {
            return Option.some((Object)"key");
        }
        if (identifier.getType().equals(JiraActivityObjectTypes.issue().iri())) {
            return Option.some((Object)StandardStreamsFilterOption.ISSUE_KEY.getKey());
        }
        return Option.none();
    }

    public Option<Boolean> getCurrentUserViewPermission(EntityIdentifier identifier) {
        return this.getCurrentUserPermission(identifier, 10);
    }

    public Option<Boolean> getCurrentUserEditPermission(EntityIdentifier identifier) {
        if (identifier.getType().equals(JiraActivityObjectTypes.issue().iri())) {
            return this.getCurrentUserPermission(identifier, 12);
        }
        return this.getCurrentUserViewPermission(identifier);
    }

    private Option<Boolean> getCurrentUserPermission(EntityIdentifier identifier, int permission) {
        User user = this.authenticationContext.getLoggedInUser();
        if (user != null) {
            Project project;
            if (identifier.getType().equals(JiraActivityObjectTypes.issue().iri())) {
                MutableIssue issue = this.issueManager.getIssueObject(identifier.getValue());
                if (issue != null) {
                    return Option.some((Object)this.permissionManager.hasPermission(permission, (Issue)issue, user));
                }
            } else if (identifier.getType().equals(JiraActivityObjectTypes.project().iri()) && (project = this.projectManager.getProjectObjByKeyIgnoreCase(identifier.getValue())) != null) {
                return Option.some((Object)this.permissionManager.hasPermission(permission, project, user));
            }
        }
        return Option.none();
    }

    private Iterable<EntityIdentifier> matchEntities(String input) {
        Project project;
        String issueKey;
        MutableIssue issue;
        Matcher matcher = PATTERN.matcher(input);
        if (!matcher.matches()) {
            return ImmutableList.of();
        }
        String projectKey = matcher.group(1);
        String issueKeySuffix = matcher.group(2);
        ImmutableList.Builder identifiers = ImmutableList.builder();
        if (StringUtils.isNotEmpty((String)issueKeySuffix) && (issue = this.issueManager.getIssueObject(issueKey = projectKey + issueKeySuffix)) != null) {
            URI canonicalUri = URI.create(this.applicationProperties.getBaseUrl() + BROWSE + issueKey);
            identifiers.add((Object)new EntityIdentifier(JiraActivityObjectTypes.issue().iri(), issueKey, canonicalUri));
        }
        if ((project = this.projectManager.getProjectObjByKeyIgnoreCase(projectKey)) != null) {
            URI canonicalUri = URI.create(this.applicationProperties.getBaseUrl() + BROWSE + projectKey);
            identifiers.add((Object)new EntityIdentifier(JiraActivityObjectTypes.project().iri(), projectKey, canonicalUri));
        }
        return identifiers.build();
    }
}

