/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.testing;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.EntityIdentifier;
import com.atlassian.streams.spi.EntityIdentifierMatchers;
import com.atlassian.streams.spi.StreamsEntityAssociationProvider;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractEntityAssociationProviderTest {
    static final String BASE_URL = "http://localhost:3990/streams";
    private static final String UNKNOWN_BASE_URL = "http://foreignhost";
    protected static final String PROJECT_ENTITY_KEY = "PROJECT";
    private static final URI UNKNOWN_ENTITY_TYPE = URI.create("http://whatever");
    protected StreamsEntityAssociationProvider provider;
    @Mock
    protected ApplicationProperties applicationProperties;

    @Before
    public void setupBase() {
        this.provider = this.createProvider();
        Mockito.when((Object)this.applicationProperties.getBaseUrl()).thenReturn((Object)BASE_URL);
        Mockito.when((Object)this.applicationProperties.getBaseUrl(UrlMode.CANONICAL)).thenReturn((Object)BASE_URL);
    }

    protected abstract StreamsEntityAssociationProvider createProvider();

    protected abstract String getProjectUriPath(String var1);

    protected abstract URI getProjectEntityType();

    protected abstract void setProjectExists(String var1, boolean var2);

    protected abstract void setProjectViewPermission(String var1, boolean var2);

    protected abstract void setProjectEditPermission(String var1, boolean var2);

    protected URI getProjectUri(String key) {
        return URI.create(BASE_URL + this.getProjectUriPath(key));
    }

    protected EntityIdentifier getProjectEntityIdentifier(String key) {
        return new EntityIdentifier(this.getProjectEntityType(), key, this.getProjectUri(key));
    }

    @Test
    public void assertThatProjectUriReturnsProjectEntityIdentifier() {
        this.setProjectExists(PROJECT_ENTITY_KEY, true);
        this.assertHasOnlyProjectKey(this.provider.getEntityIdentifiers(this.getProjectUri(PROJECT_ENTITY_KEY)), PROJECT_ENTITY_KEY);
    }

    @Test
    public void assertThatProjectUriWithRequestParametersProjectEntityIdentifier() {
        this.setProjectExists(PROJECT_ENTITY_KEY, true);
        this.assertHasOnlyProjectKey(this.provider.getEntityIdentifiers(URI.create(this.getProjectUri(PROJECT_ENTITY_KEY).toString() + "?req_param=req_value")), PROJECT_ENTITY_KEY);
    }

    @Test
    public void assertThatProjectUriWithHashReturnsProjectEntityIdentifier() {
        this.setProjectExists(PROJECT_ENTITY_KEY, true);
        this.assertHasOnlyProjectKey(this.provider.getEntityIdentifiers(URI.create(this.getProjectUri(PROJECT_ENTITY_KEY).toString() + "#myhash")), PROJECT_ENTITY_KEY);
    }

    @Test
    public void assertThatProjectKeyWithoutAbsoluteUriReturnsProjectEntityIdentifier() {
        this.setProjectExists(PROJECT_ENTITY_KEY, true);
        this.assertHasOnlyProjectKey(this.provider.getEntityIdentifiers(URI.create(PROJECT_ENTITY_KEY)), PROJECT_ENTITY_KEY);
    }

    @Test
    public void assertThatProjectUriForUnknownKeyReturnsNoIdentifier() {
        this.setProjectExists(PROJECT_ENTITY_KEY, false);
        MatcherAssert.assertThat((Object)this.provider.getEntityIdentifiers(this.getProjectUri(PROJECT_ENTITY_KEY)), EntityIdentifierMatchers.hasNoEntityIdentifiers());
    }

    @Test
    public void assertThatNonLocalUriReturnsNoEntityIdentifiers() {
        MatcherAssert.assertThat((Object)this.provider.getEntityIdentifiers(URI.create(UNKNOWN_BASE_URL)), EntityIdentifierMatchers.hasNoEntityIdentifiers());
    }

    @Test
    public void assertThatLocalUriForNonEntityReturnsNoEntityIdentifiers() {
        MatcherAssert.assertThat((Object)this.provider.getEntityIdentifiers(URI.create("http://localhost:3990/streams/some/other/url")), EntityIdentifierMatchers.hasNoEntityIdentifiers());
    }

    @Test
    public void assertThatProjectIdentifierReturnsProjectUri() {
        this.setProjectExists(PROJECT_ENTITY_KEY, true);
        MatcherAssert.assertThat((Object)this.provider.getEntityURI(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)this.getProjectUri(PROJECT_ENTITY_KEY))));
    }

    @Test
    public void assertThatProjectIdentifierReturnsProjectFilterKey() {
        MatcherAssert.assertThat((Object)this.provider.getFilterKey(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)"key")));
    }

    @Test
    public void assertThatIdentifierOfUnknownTypeReturnsNoFilterKey() {
        MatcherAssert.assertThat((Object)this.provider.getFilterKey(new EntityIdentifier(UNKNOWN_ENTITY_TYPE, PROJECT_ENTITY_KEY, URI.create(UNKNOWN_BASE_URL))), (Matcher)Matchers.equalTo((Object)Option.none(String.class)));
    }

    @Test
    public void assertThatUserViewPermissionIsTrueWhenAppropriate() {
        this.setProjectViewPermission(PROJECT_ENTITY_KEY, true);
        MatcherAssert.assertThat((Object)this.provider.getCurrentUserViewPermission(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)true)));
    }

    @Test
    public void assertThatUserViewPermissionIsFalseWhenAppropriate() {
        this.setProjectViewPermission(PROJECT_ENTITY_KEY, false);
        MatcherAssert.assertThat((Object)this.provider.getCurrentUserViewPermission(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)false)));
    }

    @Test
    public void assertThatUserViewPermissionIsUnknownWhenProjectDoesNotExist() {
        this.setProjectExists(PROJECT_ENTITY_KEY, false);
        MatcherAssert.assertThat((Object)this.provider.getCurrentUserViewPermission(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.none(Boolean.class)));
    }

    @Test
    public void assertThatUserEditPermissionIsTrueWhenAppropriate() {
        this.setProjectEditPermission(PROJECT_ENTITY_KEY, true);
        MatcherAssert.assertThat((Object)this.provider.getCurrentUserEditPermission(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)true)));
    }

    @Test
    public void assertThatUserEditPermissionIsFalseWhenAppropriate() {
        this.setProjectEditPermission(PROJECT_ENTITY_KEY, false);
        MatcherAssert.assertThat((Object)this.provider.getCurrentUserEditPermission(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)false)));
    }

    @Test
    public void assertThatUserEditPermissionIsUnknownWhenProjectDoesNotExist() {
        this.setProjectExists(PROJECT_ENTITY_KEY, false);
        MatcherAssert.assertThat((Object)this.provider.getCurrentUserEditPermission(this.getProjectEntityIdentifier(PROJECT_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.none(Boolean.class)));
    }

    private void assertHasOnlyProjectKey(Iterable<EntityIdentifier> identifiers, String key) {
        MatcherAssert.assertThat(identifiers, (Matcher)Matchers.contains((Object[])new EntityIdentifier[]{this.getProjectEntityIdentifier(key)}));
    }
}

