/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.statistics.platform;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.statistics.platform.type.AwsCloudPlatform;
import com.atlassian.statistics.platform.type.AzureCloudPlatform;
import com.atlassian.statistics.platform.type.CloudPlatform;
import com.atlassian.statistics.platform.type.CloudPlatformMetadata;
import com.atlassian.statistics.platform.type.CloudPlatformType;
import com.atlassian.statistics.platform.type.GoogleCloudPlatform;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CloudPlatformMetadataService {
    private final Logger logger = LoggerFactory.getLogger(CloudPlatformMetadataService.class);
    private final RequestFactory requestFactory;

    @Inject
    public CloudPlatformMetadataService(@ComponentImport RequestFactory requestFactory) {
        this.requestFactory = Objects.requireNonNull(requestFactory);
    }

    public Optional<CloudPlatformMetadata> getCloudPlatformMetadata() {
        for (CloudPlatformType platformType : CloudPlatformType.values()) {
            Optional<CloudPlatformMetadata> platformMetadata = this.probeCloudPlatformMetadata(platformType);
            if (!platformMetadata.isPresent()) continue;
            return platformMetadata;
        }
        return Optional.empty();
    }

    public Optional<CloudPlatformMetadata> probeCloudPlatformMetadata(CloudPlatformType platformType) {
        if (platformType == null) {
            return Optional.empty();
        }
        switch (platformType) {
            case AWS: {
                return this.probeCloudPlatformMetadata(new AwsCloudPlatform());
            }
            case AZURE: {
                return this.probeCloudPlatformMetadata(new AzureCloudPlatform());
            }
            case GOOGLE_CLOUD: {
                return this.probeCloudPlatformMetadata(new GoogleCloudPlatform());
            }
        }
        this.logger.debug("Metadata for platform type {} currently unsupported", (Object)platformType);
        return Optional.empty();
    }

    private Optional<CloudPlatformMetadata> probeCloudPlatformMetadata(CloudPlatform cloudPlatform) {
        try {
            this.logger.debug("Probing platform {}", (Object)cloudPlatform);
            CloudPlatformType platformType = cloudPlatform.getPlatformType();
            Request metadataGet = this.requestFactory.createRequest(Request.MethodType.GET, cloudPlatform.getInstanceTypeMetadataEndpoint());
            cloudPlatform.getMetadataHeaders().forEach((arg_0, arg_1) -> ((Request)metadataGet).setHeader(arg_0, arg_1));
            try {
                String payload = metadataGet.execute();
                CloudPlatformMetadata.Builder builder = CloudPlatformMetadata.builder();
                builder.cloudPlatform(platformType);
                builder.instanceType(cloudPlatform.parseInstanceType(payload));
                return Optional.of(builder.build());
            }
            catch (ResponseException e) {
                this.logger.debug("Unsuccessful request", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Unexpected error with HttpClient", (Throwable)e);
        }
        return Optional.empty();
    }
}

