define('page/admin/mailServer', [
    'jquery',
    'util/flash-notifications',
    'widget/confirm-dialog',
    'exports'
], function(
    $,
    flashNotifications,
    ConfirmDialog,
    exports) {

    exports.onReady = function(deleteButtonSelector, testButtonSelector, testAddressSelector) {

        flashNotifications.attachNotifications($('.stash-mailserver-form'), 'before');

        // bind the 'Test' button to send a test email with the current config
        var $testButton = $(testButtonSelector);
        $testButton.click(function() {
            var $this = $(this),
                $spinner = $("<div class='spinner'></div>");

            $this.nextAll().remove();
            $this.after($spinner);
            $spinner.spin();
        });

        $(testAddressSelector).keypress(function(event) {
            // so that it doesn't use the Save submit button
            if (event.which === 13) {
                event.preventDefault();
                $testButton.click();
            }
        });

        // bind the delete button
        var panelContent = stash.widget.paragraph({
            text: AJS.I18n.getText('stash.web.mailserver.delete.confirm')
        });

        var confirmDialog = new ConfirmDialog({
            id:"delete-mail-sever-config-dialog",
            titleText: AJS.I18n.getText('stash.web.mailserver.delete.config'),
            titleClass: 'warning-header',
            panelContent: panelContent,
            submitText: AJS.I18n.getText('stash.web.button.delete')
        }, { type: 'DELETE' });

        confirmDialog.attachTo(deleteButtonSelector);

        confirmDialog.addConfirmListener(function (promise) {
            promise.done(function (data) {
                flashNotifications.addNotification(
                    AJS.I18n.getText('stash.web.config.mail.deleted'),
                    'info'
                );
                window.location.reload();
            });
        });

    };
});