define('model/conflict-change', [
    'backbone-brace',
    'util/deprecation',
    'model/file-change-types',
    'model/path'
], function(
    Brace,
    deprecate,
    ChangeType,
    Path
) {
    
    "use strict";

    var ConflictChange = Brace.Model.extend({
        namedAttributes : {
            "srcPath" : Path,
            "path" : Path,
            "type" : null
        },
        initialize : function() {
            this.setType(
                ConflictChange._mapChangeType(
                    this.getType(),
                    this.getSrcPath(),
                    this.getPath()
                )
            );
        }
    }, {
        _mapChangeType : function(modState, srcPath, path) {
            return (modState === ChangeType.MOVE && srcPath && srcPath.isSameDirectory(path)) ?
                    ChangeType.RENAME :
                    ChangeType.changeTypeFromId(modState);
        }
    });


    (function (oldToJSON) {
        ConflictChange.prototype.toJSON = function() {
            var json = oldToJSON.apply(this, arguments);
            if (this.getPath()) {
                json.path = deprecate.jsonAsBrace(this.getPath(), '3.1', '4.0');
            }
            if (this.getSrcPath()) {
                json.srcPath = deprecate.jsonAsBrace(this.getSrcPath(), '3.1', '4.0');
            }
            return json;
        };
    })(ConflictChange.prototype.toJSON);

    return ConflictChange;
});