/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import java.util.BitSet;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class UriEncodingUtils {
    static final BitSet ALPHANUMERIC_CHARS;
    static final BitSet ENCODE_URI_COMPONENTS_WHITELIST;
    static final BitSet ENCODE_URI_COMPONENTS_SHELL_WHITELIST;

    private UriEncodingUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String encodeURIComponent(String component, String encoding) throws URIException {
        return URIUtil.encode((String)component, (BitSet)ENCODE_URI_COMPONENTS_WHITELIST, (String)encoding);
    }

    public static String encodeComponentForShell(String component, String encoding) throws URIException {
        return URIUtil.encode((String)component, (BitSet)ENCODE_URI_COMPONENTS_SHELL_WHITELIST, (String)encoding);
    }

    static {
        int i;
        ALPHANUMERIC_CHARS = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            ALPHANUMERIC_CHARS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            ALPHANUMERIC_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALPHANUMERIC_CHARS.set(i);
        }
        ENCODE_URI_COMPONENTS_WHITELIST = new BitSet(256);
        ENCODE_URI_COMPONENTS_WHITELIST.or(ALPHANUMERIC_CHARS);
        ENCODE_URI_COMPONENTS_WHITELIST.set(45);
        ENCODE_URI_COMPONENTS_WHITELIST.set(95);
        ENCODE_URI_COMPONENTS_WHITELIST.set(46);
        ENCODE_URI_COMPONENTS_WHITELIST.set(33);
        ENCODE_URI_COMPONENTS_WHITELIST.set(126);
        ENCODE_URI_COMPONENTS_WHITELIST.set(42);
        ENCODE_URI_COMPONENTS_WHITELIST.set(39);
        ENCODE_URI_COMPONENTS_WHITELIST.set(40);
        ENCODE_URI_COMPONENTS_WHITELIST.set(41);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST = new BitSet(256);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.or(ALPHANUMERIC_CHARS);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(45);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(95);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(46);
        ENCODE_URI_COMPONENTS_SHELL_WHITELIST.set(126);
    }
}

