/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.exception.DataStoreException;
import com.atlassian.stash.exception.NoSuchProjectException;
import com.atlassian.stash.exception.NoSuchRepositoryException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.pull.NoSuchPullRequestException;
import com.atlassian.stash.repository.Repository;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;

public abstract class ControllerSupport {
    protected final I18nService i18nService;
    protected final Logger log;

    protected ControllerSupport(I18nService i18nService) {
        this.i18nService = i18nService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    protected NoSuchProjectException newNoSuchProjectException(int projectId) {
        throw new NoSuchProjectException(this.i18nService.createKeyedMessage("stash.web.project.id.notfound", new Object[]{projectId}));
    }

    protected NoSuchProjectException newNoSuchProjectException(String projectKey) {
        throw new NoSuchProjectException(this.i18nService.createKeyedMessage("stash.web.project.key.notfound", new Object[]{projectKey}));
    }

    protected NoSuchPullRequestException newNoSuchPullRequestException(Repository repository, long pullRequestId) {
        throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("stash.web.pullrequest.notfound", new Object[]{pullRequestId, repository.getSlug(), repository.getProject().getName()}));
    }

    protected NoSuchRepositoryException newNoSuchRepositoryException(int repoId) {
        throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("stash.web.repository.id.notfound", new Object[]{repoId}), (Project)null);
    }

    protected NoSuchRepositoryException newNoSuchRepositoryException(Project project, String repoSlug) {
        KeyedMessage msg = project.getType() == ProjectType.PERSONAL ? this.i18nService.createKeyedMessage("stash.web.personal.repository.slug.notfound", new Object[]{repoSlug, project.getName()}) : this.i18nService.createKeyedMessage("stash.web.repository.slug.notfound", new Object[]{repoSlug, project.getName()});
        throw new NoSuchRepositoryException(msg, project);
    }

    protected NoSuchUserException newNoSuchUserBySlugException(String slug) {
        throw new NoSuchUserException(this.i18nService.createKeyedMessage("stash.web.user.slug.notfound", new Object[]{slug}), slug);
    }

    protected void rejectException(Errors errors, ServiceException e) {
        errors.reject(e.getMessageKey(), e.getLocalizedMessage());
        if (e instanceof DataStoreException) {
            this.log.error("Exception occurred", (Throwable)e);
        } else {
            this.log.debug("Exception occurred", (Throwable)e);
        }
    }

    protected void rejectException(Errors errors, ConstraintViolationException e) {
        for (ConstraintViolation violation : e.getConstraintViolations()) {
            errors.rejectValue(violation.getPropertyPath().toString(), violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), violation.getMessage());
        }
    }

    protected void streamAvatar(CacheableAvatarSupplier supplier, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        long timestamp = supplier.getTimestamp();
        if (timestamp != 0L) {
            if (modifiedSince > 0L && (timestamp == -1L || TimeUnit.MILLISECONDS.toSeconds(modifiedSince) >= TimeUnit.MILLISECONDS.toSeconds(timestamp))) {
                response.sendError(304);
                return;
            }
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Last-Modified", timestamp);
        }
        response.setContentType(supplier.getContentType());
        ByteStreams.copy((InputSupplier)supplier, (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }
}

