/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.stash.internal.web.fragments.WebFragmentData;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.fragments.WebSectionData;
import com.atlassian.stash.internal.web.soy.functions.AbstractWebFragmentFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.util.Weighted;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebFragmentFunction
extends AbstractWebFragmentFunction<WebFragmentData> {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)1, (int)3);

    public WebFragmentFunction(WebInterfaceManager webInterfaceManager, StashAuthenticationContext authenticationContext, HttpContext httpContext) {
        super(webInterfaceManager, authenticationContext, httpContext);
    }

    public String getName() {
        return "getWebFragments";
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("WebFragments.getWebFragments(" + args[0].getText() + "," + args[1].getText() + (args.length > 2 ? "," + args[2].getText() : "") + ")");
    }

    public List<WebFragmentData> apply(Object ... args) {
        int contextArgIndex;
        String locationSections;
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (Object)"invalid number of arguments");
        String locationItems = (String)args[0];
        if (args.length > 1 && args[1] instanceof String) {
            locationSections = (String)args[1];
            contextArgIndex = 2;
        } else {
            locationSections = locationItems;
            contextArgIndex = 1;
        }
        HashMap context = args.length > contextArgIndex ? (Map)args[contextArgIndex] : Maps.newHashMap();
        List items = this.getWebItems(locationItems, (Map)context);
        List sections = this.getWebSections(locationSections, (Map)context);
        return this.combineByWeight(items, sections);
    }

    private List<WebFragmentData> combineByWeight(List<WebItemData> items, List<WebSectionData> sections) {
        ArrayList<WebFragmentData> fragments = new ArrayList<WebFragmentData>(items.size() + sections.size());
        fragments.addAll(items);
        fragments.addAll(sections);
        Collections.sort(fragments, Weighted.COMPARABLE);
        return fragments;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

