/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class SubStringFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    public static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)2, (Object)3);

    public String getName() {
        return "substring";
    }

    public JsExpression generate(JsExpression ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(args[0].getText()).append(".substring(").append(args[1].getText());
        if (args.length == 3) {
            sb.append(", ").append(args[2].getText());
        }
        sb.append(")");
        return new JsExpression(sb.toString());
    }

    public String apply(Object ... args) {
        String parent = (String)args[0];
        int beginIndex = ((Number)args[1]).intValue();
        if (args.length == 2) {
            return parent.substring(beginIndex);
        }
        int endIndex = ((Number)args[2]).intValue();
        return parent.substring(beginIndex, endIndex);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

