/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class HighlightTextFunction
implements SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)2, (Object)3);

    public JsExpression generate(JsExpression ... jsExpressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("require('util/highlight-text').highlight(").append(jsExpressions[0].getText()).append(", ").append(jsExpressions[1].getText());
        if (jsExpressions.length > 2) {
            sb.append(", ").append(jsExpressions[2].getText());
        }
        sb.append(")");
        return new JsExpression(sb.toString());
    }

    public String getName() {
        return "highlight";
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

