/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class CamelCaseToHyphenatedFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    public static final Set<Integer> VALID_ARG_SIZES = Collections.singleton(1);

    public String getName() {
        return "camel_case_to_hyphenated";
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("require('util/text').camelCaseToHyphenated(" + args[0].getText() + ")");
    }

    public String apply(Object ... args) {
        Object text = args[0];
        Preconditions.checkArgument((boolean)(text instanceof String), (Object)("invalid argument: " + text));
        return this.hyphenate((String)text);
    }

    private String hyphenate(String text) {
        return text.replaceAll("(?<=[^-_\\s])([A-Z])", "-$1").replaceAll("\\s", "-").toLowerCase(Locale.US);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

