/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.fragments.WebFragmentData;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.fragments.WebSectionData;
import com.atlassian.stash.user.StashAuthenticationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

abstract class AbstractWebFragmentFunction<T extends WebFragmentData>
implements SoyServerFunction<List<T>>,
SoyClientFunction {
    private final StashAuthenticationContext authenticationContext;
    private final WebInterfaceManager webInterfaceManager;
    private final HttpContext httpContext;

    public AbstractWebFragmentFunction(WebInterfaceManager webInterfaceManager, StashAuthenticationContext authenticationContext, HttpContext httpContext) {
        this.authenticationContext = authenticationContext;
        this.webInterfaceManager = webInterfaceManager;
        this.httpContext = httpContext;
    }

    protected List<WebItemData> getWebItems(String location, Map<String, Object> requestedContext) {
        HttpServletRequest request = this.httpContext.getRequest();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("request", request);
        context.put("currentUser", this.authenticationContext.getCurrentUser());
        context.putAll(requestedContext);
        List items = this.webInterfaceManager.getDisplayableItems(location, context);
        ArrayList<WebItemData> webItems = new ArrayList<WebItemData>(items.size());
        for (WebItemModuleDescriptor wimd : items) {
            webItems.add(new WebItemData(wimd.getLink() == null ? null : wimd.getLink().getDisplayableUrl(request, context), wimd.getPluginKey(), wimd.getKey(), wimd.getWebLabel() == null ? null : wimd.getWebLabel().getDisplayableLabel(request, context), wimd.getTooltip() == null ? null : wimd.getTooltip().getDisplayableLabel(request, context), wimd.getIcon() == null ? null : wimd.getIcon().getUrl().getDisplayableUrl(request, context), wimd.getIcon() == null ? 0 : wimd.getIcon().getWidth(), wimd.getIcon() == null ? 0 : wimd.getIcon().getHeight(), wimd.getStyleClass(), wimd.getLink() == null ? null : wimd.getLink().getId(), wimd.getDescription(), wimd.getWeight(), wimd.getParams()));
        }
        if (request != null && request.getParameter("web.items") != null) {
            webItems.add(this.createExampleWebItem(location, context));
        }
        return webItems;
    }

    protected List<WebSectionData> getWebSections(String location, Map<String, Object> requestedContext) {
        HttpServletRequest request = this.httpContext.getRequest();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("request", request);
        context.putAll(requestedContext);
        List sections = this.webInterfaceManager.getDisplayableSections(location, context);
        ArrayList<WebSectionData> webSectionData = new ArrayList<WebSectionData>(sections.size());
        for (WebSectionModuleDescriptor wsmd : sections) {
            webSectionData.add(new WebSectionData(wsmd.getName(), wsmd.getKey(), wsmd.getLocation(), wsmd.getWebLabel() == null ? null : wsmd.getWebLabel().getDisplayableLabel(request, context), wsmd.getWeight()));
        }
        if (request != null && request.getParameter("web.sections") != null) {
            webSectionData.add(this.createExampleWebSection(location, context));
        }
        return webSectionData;
    }

    private WebItemData createExampleWebItem(String location, Map<String, Object> context) {
        return new WebItemData("#example-web-item-url", "org.example.plugins", "example-web-item", "Web Item: " + location, "Context Items: " + StringUtils.join(context.keySet(), (String)", "), null, 0, 0, "plugin-point", null, null, Integer.MAX_VALUE, new HashMap());
    }

    private WebSectionData createExampleWebSection(String location, Map<String, Object> context) {
        return new WebSectionData("example-web-section", "example-web-section", location, "Web Section: " + location, Integer.MAX_VALUE);
    }
}

