/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.setup;

import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.soy.springmvc.errors.ErrorUtils;
import com.atlassian.stash.exception.LicenseException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.db.DbTypeBean;
import com.atlassian.stash.internal.db.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.internal.migration.MigrationService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.web.admin.DbConfigForm;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.locale.UserLocaleWebUtils;
import com.atlassian.stash.internal.web.setup.AdminUserForm;
import com.atlassian.stash.internal.web.setup.JiraIntegrationForm;
import com.atlassian.stash.internal.web.setup.SettingsForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.jira.IncorrectStashBaseUrlException;
import com.atlassian.stash.jira.JiraSetupException;
import com.atlassian.stash.jira.JiraSetupService;
import com.atlassian.stash.jira.JiraUserCredentialsException;
import com.atlassian.stash.jira.NotAJiraServerException;
import com.atlassian.stash.jira.StashApplicationTypeNotInstalledException;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.user.EscalatedSecurityContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.UserAdminService;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.DevModeUtils;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UrlUtils;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Conventions;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/setup"})
public class SetupController
extends ControllerSupport {
    static final String HAS_SETUP_DB_NAME = Conventions.getQualifiedAttributeName(SetupController.class, (String)"hasSetupDatabase");
    static final String DATABASE_VIEW = "stash.page.setup.database";
    static final String LICENSE_AND_SETTINGS_VIEW = "stash.page.setup.settings";
    static final String ADMIN_USER_VIEW = "stash.page.setup.adminUser";
    static final String JIRA_INTEGRATION_VIEW = "stash.page.setup.jiraIntegration";
    static final String JIRA_UPM_INSTALL_URL_SUFFIX = "/plugins/servlet/upm#upgrade";
    private final AtomicBoolean isSettingUpDatabase;
    private final JiraSetupService jiraSetupService;
    private final InternalLanguageService languageService;
    private final LicenseService licenseService;
    private final MigrationService migrationService;
    private final NavBuilder navBuilder;
    private final PermissionAdminService permissionAdminService;
    private final InternalPermissionService permissionService;
    private final InternalApplicationPropertiesService propertiesService;
    private final EscalatedSecurityContext asSysAdmin;
    private final UserAdminService userAdminService;
    private final UserService userService;

    @Autowired
    public SetupController(I18nService i18nService, JiraSetupService jiraSetupService, InternalLanguageService languageService, LicenseService licenseService, MigrationService migrationService, NavBuilder navBuilder, PermissionAdminService permissionAdminService, InternalPermissionService permissionService, InternalApplicationPropertiesService propertiesService, SecurityService securityService, UserAdminService userAdminService, UserService userService) {
        super(i18nService);
        this.permissionService = permissionService;
        this.permissionAdminService = permissionAdminService;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.propertiesService = propertiesService;
        this.asSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "SetupContoller");
        this.jiraSetupService = jiraSetupService;
        this.languageService = languageService;
        this.licenseService = licenseService;
        this.navBuilder = navBuilder;
        this.migrationService = migrationService;
        this.isSettingUpDatabase = new AtomicBoolean(false);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView setup(HttpSession session) {
        if (this.isSettingUpDatabase.get()) {
            return this.showDatabaseProgress().build();
        }
        if (this.propertiesService.isSetup()) {
            return this.goToDashboard();
        }
        if (!this.hasSetupDatabase(session)) {
            return this.getDatabaseForm(DbTypeBean.DEFAULT, null, true).build();
        }
        if (!this.hasLicense()) {
            return this.getSettingsForm(null).build();
        }
        if (!this.hasAdminUser()) {
            return this.getAdminUserForm().build();
        }
        return this.getJiraForm().build();
    }

    private StashSoyResponseBuilder getAdminUserForm() {
        return this.setupSoyResponseBuilder(ADMIN_USER_VIEW);
    }

    private StashSoyResponseBuilder getDatabaseForm(DbTypeBean currentDbType, DbConfigForm form, boolean isInternal) {
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(DATABASE_VIEW).put("currentDbType", (Object)currentDbType)).put("dbTypes", (Object)DbTypeBean.ALL)).put("isInternal", (Object)isInternal)).put("languages", (Object)UserLocaleWebUtils.toSoy((Iterable)this.languageService.getLanguages(), (String)this.propertiesService.getLocale().toString()))).put("form", (Object)form);
    }

    private StashSoyResponseBuilder showDatabaseProgress() {
        throw new UnsupportedOperationException();
    }

    private StashSoyResponseBuilder getSettingsForm(SettingsForm form) {
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(LICENSE_AND_SETTINGS_VIEW).put("serverId", (Object)this.propertiesService.getServerId())).put("generateEvalUrl", (Object)this.getGenerateEvalUrl())).put("form", (Object)form);
    }

    private StashSoyResponseBuilder getJiraForm() {
        URI baseUrl = this.propertiesService.getBaseUrl();
        return (StashSoyResponseBuilder)this.setupSoyResponseBuilder(JIRA_INTEGRATION_VIEW).put("form", (Object)new JiraIntegrationForm(baseUrl == null ? null : baseUrl.toASCIIString()));
    }

    @RequestMapping(params={"step=database"}, method={RequestMethod.POST})
    public ModelAndView configureDatabase(HttpServletRequest request, HttpSession session, @RequestParam(value="internal", defaultValue="true") boolean isInternal, @RequestParam(value="locale", required=false) String locale, @Valid DbConfigForm form, Errors errors) {
        this.checkSetupNotComplete();
        this.setLocale(locale);
        if (this.hasSetupDatabase(session)) {
            return this.showNextStep();
        }
        DbTypeBean currentDbType = DbTypeBean.forKey((String)form.getType());
        if (currentDbType == null) {
            errors.rejectValue("type", "stash.web.setup.database.type.required", "You must select database type");
        }
        if (!isInternal && errors.hasErrors()) {
            return this.getDatabaseForm(currentDbType, form, isInternal).putValidationErrors(errors).build();
        }
        if (isInternal) {
            this.markDatabaseAsSetup(session);
        } else {
            String jdbcUrl = currentDbType.generateUrl(form.getHostname(), form.getDatabase(), form.getPortAsInteger());
            SimpleDataSourceConfiguration configuration = new SimpleDataSourceConfiguration(currentDbType.getDriverClassName(), jdbcUrl, form.getUsername(), form.getPassword());
            try {
                if (request.getParameter("test") != null) {
                    this.performTestDatabaseConnection((DataSourceConfiguration)configuration);
                    return ((StashSoyResponseBuilder)this.getDatabaseForm(currentDbType, form, isInternal).put("testPassed", (Object)true)).build();
                }
                this.performDatabaseSetup(session, (DataSourceConfiguration)configuration);
            }
            catch (MigrationException e) {
                return ((StashSoyResponseBuilder)this.getDatabaseForm(currentDbType, form, isInternal).put("migrationException", (Object)e)).build();
            }
            catch (ServiceException e) {
                return this.getDatabaseForm(currentDbType, form, isInternal).putFormErrors(e).build();
            }
        }
        return this.showNextStep();
    }

    private void performTestDatabaseConnection(DataSourceConfiguration configuration) {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void performDatabaseSetup(HttpSession session, DataSourceConfiguration configuration) {
        MaintenanceTaskMonitor task = (MaintenanceTaskMonitor)this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
        this.isSettingUpDatabase.set(true);
        task.registerCallback((MaintenanceCompletionCallback)new /* Unavailable Anonymous Inner Class!! */);
        try {
            task.awaitCompletion();
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("An unexpected exception occurred while setting up the database", (Throwable)e);
        }
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView callbackForMac(@Valid SettingsForm form, Errors errors) {
        this.checkSetupNotComplete();
        return this.getSettingsForm(form).build();
    }

    @RequestMapping(params={"step=settings"}, method={RequestMethod.POST})
    public ModelAndView enterSettings(@Valid SettingsForm form, Errors errors) {
        this.checkSetupNotComplete();
        if (errors.hasErrors()) {
            return this.getSettingsForm(form).putValidationErrors(errors).build();
        }
        try {
            this.setNameAndBaseUrl(form.getApplicationTitle(), form.getBaseUrl());
            this.setLicense(form.getLicense());
        }
        catch (LicenseException e) {
            Map<String, List<String>> fieldErrors = Collections.singletonMap("license", Collections.singletonList(e.getLocalizedMessage()));
            return ((StashSoyResponseBuilder)this.getSettingsForm(form).putFieldErrors(fieldErrors)).build();
        }
        catch (ServiceException e) {
            return ((StashSoyResponseBuilder)this.getSettingsForm(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        return this.showNextStep();
    }

    @RequestMapping(params={"step=user"}, method={RequestMethod.POST})
    public ModelAndView addFirstAdminUser(@Valid AdminUserForm form, Errors errors) {
        this.checkSetupNotComplete();
        if (errors.hasErrors()) {
            return this.showForm(ADMIN_USER_VIEW, (Object)form, errors, new String[0]);
        }
        try {
            this.createAdminUser(form);
        }
        catch (Exception e) {
            return this.showForm(ADMIN_USER_VIEW, (Object)form, null, new String[]{ErrorUtils.getLocalizedMessageOfRootCause((Throwable)e)});
        }
        if (!form.isIntegrateWithJira()) {
            this.markSetupAsComplete();
        }
        return this.showNextStep();
    }

    @RequestMapping(params={"step=jira"}, method={RequestMethod.POST})
    public ModelAndView setupJiraIntegration(@Valid JiraIntegrationForm form, Errors errors) {
        this.checkSetupNotComplete();
        if (!form.isSkip()) {
            if (errors.hasErrors()) {
                return this.showForm(JIRA_INTEGRATION_VIEW, (Object)form, errors, new String[0]);
            }
            try {
                this.integrateWithJira(form);
            }
            catch (NotAJiraServerException e) {
                errors.rejectValue("jiraBaseUrl", "stash.web.setup.stash.bad.jira.url", e.getLocalizedMessage());
                return this.showForm(JIRA_INTEGRATION_VIEW, (Object)form, errors, new String[0]);
            }
            catch (JiraUserCredentialsException e) {
                return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(JIRA_INTEGRATION_VIEW).put("form", (Object)form)).put("credentialsProblem", (Object)true)).build();
            }
            catch (IncorrectStashBaseUrlException e) {
                errors.rejectValue("stashBaseUrl", "stash.web.setup.stash.bad.stash.url", e.getLocalizedMessage());
                return this.showForm(JIRA_INTEGRATION_VIEW, (Object)form, errors, new String[0]);
            }
            catch (StashApplicationTypeNotInstalledException e) {
                return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(JIRA_INTEGRATION_VIEW).put("form", (Object)form)).put("stashUalTypesMissing", (Object)true)).put("jiraUpmUrl", (Object)UrlUtils.concatenate((String)form.getJiraBaseUrl(), (String[])new String[]{JIRA_UPM_INSTALL_URL_SUFFIX}))).build();
            }
            catch (JiraSetupException e) {
                return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(JIRA_INTEGRATION_VIEW).put("form", (Object)form)).put("jiraIntegrationError", (Object)e.getLocalizedMessage())).build();
            }
        }
        this.markSetupAsComplete();
        return this.goToDashboard();
    }

    private boolean hasSetupDatabase(HttpSession session) {
        return Boolean.TRUE.equals(session.getAttribute(HAS_SETUP_DB_NAME)) || !this.propertiesService.getJdbcDriver().startsWith("org.hsqldb");
    }

    private boolean hasLicense() {
        return this.licenseService.isPresent();
    }

    private void setNameAndBaseUrl(String name, String baseURL) {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setLicense(String license) {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setLocale(String locale) {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean hasAdminUser() {
        return (Boolean)this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createAdminUser(AdminUserForm form) throws CrowdException {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void integrateWithJira(JiraIntegrationForm form) throws JiraSetupException {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ModelAndView showForm(String formView, Object form, Errors errors, String ... globalErrors) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(formView).put("form", form)).putFormErrors(globalErrors);
        if (errors != null) {
            builder.putValidationErrors(errors);
        }
        return builder.build();
    }

    private void markDatabaseAsSetup(HttpSession session) {
        session.setAttribute(HAS_SETUP_DB_NAME, (Object)Boolean.TRUE);
    }

    private void markSetupAsComplete() {
        this.asSysAdmin.call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkSetupNotComplete() {
        if (this.propertiesService.isSetup()) {
            throw new IllegalStateException("Stash is already setup!");
        }
    }

    private ModelAndView showNextStep() {
        return new ModelAndView("redirect:/setup");
    }

    private ModelAndView goToDashboard() {
        return new ModelAndView("redirect:/");
    }

    private String getGenerateEvalUrl() {
        String callback = this.navBuilder.setup().buildAbsolute();
        return "http://www.atlassian.com/ex/GenerateLicense.jspa" + "?utm_nooverride=1" + "&ref=prod" + "&product=" + ApplicationConstants.PRODUCT_NAME + "&version=" + this.propertiesService.getBuildVersion() + "&build=" + this.propertiesService.getBuildNumber() + "&sid=" + this.propertiesService.getServerId() + "&licensefieldname=" + "license" + "&callback=" + callback;
    }

    private StashSoyResponseBuilder setupSoyResponseBuilder(@Nonnull String viewName) {
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(viewName);
        Map da = responseBuilder.getDataAttributes();
        da.put("server-id", this.propertiesService.getServerId());
        da.put("dev-mode-enabled", Boolean.toString(DevModeUtils.isEnabled()));
        return responseBuilder;
    }

    static /* synthetic */ MigrationService access$000(SetupController x0) {
        return x0.migrationService;
    }

    static /* synthetic */ Logger access$100(SetupController x0) {
        return x0.log;
    }

    static /* synthetic */ AtomicBoolean access$200(SetupController x0) {
        return x0.isSettingUpDatabase;
    }

    static /* synthetic */ void access$300(SetupController x0, HttpSession x1) {
        x0.markDatabaseAsSetup(x1);
    }

    static /* synthetic */ Logger access$400(SetupController x0) {
        return x0.log;
    }

    static /* synthetic */ InternalApplicationPropertiesService access$500(SetupController x0) {
        return x0.propertiesService;
    }

    static /* synthetic */ LicenseService access$600(SetupController x0) {
        return x0.licenseService;
    }

    static /* synthetic */ InternalPermissionService access$700(SetupController x0) {
        return x0.permissionService;
    }

    static /* synthetic */ UserAdminService access$800(SetupController x0) {
        return x0.userAdminService;
    }

    static /* synthetic */ UserService access$900(SetupController x0) {
        return x0.userService;
    }

    static /* synthetic */ I18nService access$1000(SetupController x0) {
        return x0.i18nService;
    }

    static /* synthetic */ PermissionAdminService access$1100(SetupController x0) {
        return x0.permissionAdminService;
    }

    static /* synthetic */ JiraSetupService access$1200(SetupController x0) {
        return x0.jiraSetupService;
    }
}

