/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.RepositoryAccessedEvent;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RepositoryAccessInterceptor
extends HandlerInterceptorAdapter {
    private static final Pattern REPO_PATH_PATTERN = Pattern.compile(String.format("/projects/(~?%s)/repos/(%s)/.*", "[a-zA-Z][a-zA-Z0-9_\\-]*", "[\\p{Alnum}][\\w\\-\\.]*"));
    private static final Logger log = LoggerFactory.getLogger(RepositoryAccessInterceptor.class);
    private final EventPublisher eventPublisher;
    private final RepositoryService repositoryService;

    public RepositoryAccessInterceptor(EventPublisher eventPublisher, RepositoryService repositoryService) {
        this.eventPublisher = eventPublisher;
        this.repositoryService = repositoryService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            Matcher matcher = REPO_PATH_PATTERN.matcher(request.getPathInfo());
            if (matcher.matches()) {
                this.maybeFireRepositoryAccessed(matcher.group(1), matcher.group(2));
            }
        }
        catch (Exception e) {
            log.warn("Failed to fire event for repository access", (Throwable)e);
        }
        return true;
    }

    private void maybeFireRepositoryAccessed(String projectKey, String repositorySlug) {
        try {
            Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
            if (repository != null) {
                this.eventPublisher.publish((Object)new RepositoryAccessedEvent((Object)this, repository));
            }
        }
        catch (AuthorisationException authorisationException) {
            // empty catch block
        }
    }
}

