/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.pull;

import com.atlassian.stash.commit.CommitService;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.exception.NoDefaultBranchException;
import com.atlassian.stash.exception.NoSuchChangesetException;
import com.atlassian.stash.exception.RequestCanceledException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.web.pull.PullRequestForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.atlassian.stash.internal.web.util.StashWebErrorUtils;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.pull.DuplicatePullRequestException;
import com.atlassian.stash.pull.InvalidPullRequestReviewersException;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestDirection;
import com.atlassian.stash.pull.PullRequestOrder;
import com.atlassian.stash.pull.PullRequestSearchRequest;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.ui.PluginFormFragments;
import com.atlassian.stash.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/pull-requests"})
public class PullRequestController
extends RepositoryControllerSupport {
    static final String VIEW = "stash.page.pullRequest.view";
    static final String OVERVIEW_KEY = "stash.pull-request.nav.overview";
    static final String COMMITS_KEY = "stash.pull-request.nav.commits";
    static final String DIFF_KEY = "stash.pull-request.nav.diff";
    static final String COMMIT_LIST_FRAGMENT = "stash.feature.commits.commitsTable";
    static final String CREATE_VIEW = "stash.page.createPullRequest";
    static final String CREATE_FORM_PLUGIN_HANDLER_KEY = "stash.page.createPullRequest";
    static final String LIST_VIEW = "stash.page.pullRequest.list";
    static final String LIST_VIEW_TAB_PREFIX = "stash.pull-requests.list.nav.";
    private final CommitService commitService;
    private final NavBuilder navBuilder;
    private final InternalPullRequestService pullRequestService;
    private final UserService userService;
    private final PluginFormFragmentsFactory fragmentsFactory;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${pullrequest.diff.context}")
    private int relevantContextLines;

    @Autowired
    public PullRequestController(InternalProjectService projectService, RepositoryService repositoryService, RepositoryMetadataService metadataService, CommitService commitService, PluginFormFragmentsFactory fragmentsFactory, I18nService i18nService, NavBuilder navBuilder, PermissionService permissionService, InternalPullRequestService pullRequestService, UserService userService) {
        super(i18nService, projectService, repositoryService, metadataService, permissionService);
        this.commitService = commitService;
        this.fragmentsFactory = fragmentsFactory;
        this.navBuilder = navBuilder;
        this.pullRequestService = pullRequestService;
        this.userService = userService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView createPullRequest(WebRequest request, @PathVariable(value="projectKey") String toProjectKey, @PathVariable(value="repoSlug") String toRepoSlug, @Valid PullRequestForm form, Errors errors) {
        Repository fromRepository = this.getRepository(form.getFromRepoId());
        Repository toRepository = this.getRepository(toProjectKey, toRepoSlug);
        if (this.isEmptyRepository(fromRepository)) {
            return this.handleEmptyRepo(fromRepository);
        }
        if (this.isEmptyRepository(toRepository)) {
            return this.handleEmptyRepo(toRepository);
        }
        Set reviewers = this.parseReviewers(form.getReviewers());
        Set resolvedReviewers = null;
        PullRequest existingPullRequest = null;
        String fromBranch = form.getFromBranch();
        String toBranch = form.getToBranch();
        HashMap formFragmentContext = Maps.newHashMap();
        formFragmentContext.put("fromRepository", fromRepository);
        formFragmentContext.put("toRepository", toRepository);
        PluginFormFragments pluginFormFragments = this.fragmentsFactory.forKey("stash.page.createPullRequest", (Map)formFragmentContext);
        PluginValidationErrors pluginValidationErrors = new PluginValidationErrors(errors);
        pluginFormFragments.validate(request.getParameterMap(), (ValidationErrors)pluginValidationErrors);
        ImmutableList detailedErrors = null;
        if (!pluginValidationErrors.hasFieldErrors() && !errors.hasErrors()) {
            try {
                PullRequest pullRequest = this.pullRequestService.create(form.getTitle(), form.getDescription(), reviewers, fromRepository, fromBranch, toRepository, toBranch);
                formFragmentContext.put("pullRequest", pullRequest);
                pluginFormFragments = this.fragmentsFactory.forKey("stash.page.createPullRequest", (Map)formFragmentContext);
                pluginFormFragments.execute(request.getParameterMap());
                return new ModelAndView((View)new RedirectView(this.navBuilder.repo(toRepository).pullRequest(pullRequest.getId().longValue()).buildRelative()));
            }
            catch (DuplicatePullRequestException e) {
                existingPullRequest = e.getExistingPullRequest();
            }
            catch (InvalidPullRequestReviewersException e) {
                resolvedReviewers = e.getValidReviewers();
                for (KeyedMessage keyedMessage : e.getReviewerErrors().values()) {
                    errors.rejectValue("reviewers", keyedMessage.getKey(), keyedMessage.getLocalisedMessage());
                }
            }
            catch (RequestCanceledException e) {
                detailedErrors = ImmutableList.of((Object)StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        if (resolvedReviewers == null) {
            resolvedReviewers = this.resolveReviewers(reviewers);
        }
        String pluginFieldsContent = pluginFormFragments.getErrorHtml(request.getParameterMap(), pluginValidationErrors.getFieldErrors());
        return this.getCreateViewBuilder(fromRepository, fromBranch, toRepository, toBranch, form.getTitle(), form.getDescription(), resolvedReviewers, pluginFieldsContent).putDetailedErrors((Iterable)detailedErrors).putValidationErrors(errors).putIfNotNull("existingPullRequest", (Object)existingPullRequest).build();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"create"})
    public ModelAndView createPullRequestView(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId, @RequestParam(value="title", required=false) String title, @RequestParam(value="description", required=false) String description, @RequestParam(value="reviewers", required=false) String reviewers) {
        Repository fromRepository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(fromRepository)) {
            return this.handleEmptyRepo(fromRepository);
        }
        Repository toRepository = this.getTargetRepository(fromRepository, targetRepoId);
        Repository fork = this.repositoryService.findPersonalFork(fromRepository);
        ImmutableSet preloadRepositories = fork == null ? null : ImmutableSet.of((Object)fork);
        HashMap context = Maps.newHashMap();
        context.put("fromRepository", fromRepository);
        context.put("toRepository", toRepository);
        String pluginFieldsContent = this.fragmentsFactory.forKey("stash.page.createPullRequest", (Map)context).getViewHtml();
        return this.getCreateViewBuilder(fromRepository, fromBranch, toRepository, toBranch, title, description, this.resolveReviewers(this.parseReviewers(reviewers)), pluginFieldsContent).putIfNotNull("additionalPreloadRepositories", (Object)preloadRepositories).build();
    }

    private Set<String> parseReviewers(String reviewersField) {
        if (StringUtils.isBlank((String)reviewersField)) {
            return Collections.emptySet();
        }
        HashSet reviewers = Sets.newHashSet();
        for (String reviewer : reviewersField.split("\\|!\\|")) {
            reviewers.add(reviewer.trim());
        }
        return reviewers;
    }

    private Set<StashUser> resolveReviewers(Set<String> reviewers) {
        return Chainable.chain(reviewers).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toSet();
    }

    private StashSoyResponseBuilder getCreateViewBuilder(Repository fromRepository, String fromBranch, Repository toRepository, String toBranch, String title, String description, Set<StashUser> reviewers, String pluginFieldsContent) {
        StashSoyResponseBuilder builder = ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.createPullRequest").put("pluginFieldsContent", (Object)pluginFieldsContent)).put("sourceRepository", (Object)fromRepository)).put("maxChanges", (Object)this.maxChanges)).putRepository(toRepository).putIfNotBlank("title", title).putIfNotBlank("description", description).putIfNotNull("reviewers", reviewers);
        String fromCsId = null;
        if (StringUtils.isNotEmpty((String)fromBranch)) {
            Ref fromBranchRef = this.resolveRefOrFail(fromRepository, fromBranch);
            builder.put("sourceBranch", (Object)fromBranchRef);
            Changeset sourceChangeset = this.commitService.getChangeset(fromRepository, fromBranchRef.getLatestChangeset());
            builder.putIfNotNull("sourceChangeset", (Object)sourceChangeset);
        }
        String toCsId = null;
        try {
            Branch toBranchRef = StringUtils.isBlank((String)toBranch) ? this.metadataService.getDefaultBranch(toRepository) : this.resolveRefOrFail(toRepository, toBranch);
            builder.put("targetBranch", (Object)toBranchRef);
            Changeset targetChangeset = this.commitService.getChangeset(toRepository, toBranchRef.getLatestChangeset());
            builder.putIfNotNull("targetChangeset", (Object)targetChangeset);
        }
        catch (NoDefaultBranchException e) {
            this.log.debug("No default branch set on {}/{}", (Object)toRepository.getProject().getKey(), (Object)toRepository.getSlug());
        }
        if (fromCsId != null && toCsId != null) {
            ChangesetsBetweenRequest changesetsBetween = new ChangesetsBetweenRequest.Builder(toRepository).exclude(toCsId, new String[0]).include(fromCsId, new String[0]).secondaryRepository(fromRepository).build();
            PageRequest pageRequest = PageUtils.newRequest((int)0, (int)10);
            builder.put("changesetPage", (Object)this.commitService.getChangesetsBetween(changesetsBetween, pageRequest));
        }
        return builder;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView listPullRequestsView(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="state", required=false, defaultValue="OPEN") String state, @RequestParam(value="direction", required=false, defaultValue="INCOMING") String direction, @RequestParam(value="at", required=false) String branch, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit, @RequestParam(value="order", required=false) String order) {
        if (!this.permissionService.hasGlobalPermission(Permission.LICENSED_USER)) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.pullrequest.view.accessdenied", new Object[0]));
        }
        Repository repository = this.getRepository(projectKey, repoSlug);
        PullRequestState prState = this.getPullRequestState(state);
        PullRequestDirection prDirection = this.getPullRequestDirection(direction);
        PullRequestOrder resultsOrder = PullRequestOrder.fromString((String)order, (PullRequestOrder)PullRequestOrder.getDefaultOrderForState((PullRequestState)prState));
        PageRequest pageRequest = PageUtils.newRequest((int)start, (int)limit);
        Page pullRequestPage = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(prDirection, repository.getId(), branch).state(prState).order(resultsOrder).build(), pageRequest);
        String activeTab = null;
        if (prDirection == PullRequestDirection.OUTGOING) {
            if (prState == PullRequestState.OPEN) {
                activeTab = LIST_VIEW_TAB_PREFIX + prDirection.name().toLowerCase(Locale.US);
            } else {
                this.log.warn("No matching active tab for {} {} pull-requests", (Object)prDirection.name().toLowerCase(Locale.US), (Object)prState.name().toLowerCase(Locale.US));
            }
        } else {
            activeTab = LIST_VIEW_TAB_PREFIX + prState.name().toLowerCase(Locale.US);
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(LIST_VIEW).putRepository(repository).put("pullRequestState", (Object)state)).put("pullRequestPage", (Object)pullRequestPage)).putIfNotNull("pullRequestOrder", resultsOrder == null ? null : resultsOrder.name().toLowerCase(Locale.US)).put("activeTab", (Object)activeTab)).build();
    }

    @RequestMapping(value={"/{pullRequestId}"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequest(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        return new ModelAndView((View)new RedirectView(this.navBuilder.project(projectKey).repo(repoSlug).pullRequest(pullRequestId).overview().buildRelative()));
    }

    @RequestMapping(value={"/{pullRequestId}/activity"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestActivity(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        return this.viewPullRequest(projectKey, repoSlug, pullRequestId);
    }

    @RequestMapping(value={"/{pullRequestId}/overview"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestOverview(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        PullRequest pullRequest = this.getPullRequest(repository, pullRequestId);
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).putRepository(repository).putPullRequest(pullRequest).put("maxChanges", (Object)this.maxChanges)).put("startingTabKey", (Object)OVERVIEW_KEY)).build();
    }

    @RequestMapping(value={"/{pullRequestId}/commits"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestCommits(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit, @RequestParam(value="contents", required=false, defaultValue="false") boolean contentsOnly, HttpServletResponse response) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        PullRequest pullRequest = this.getPullRequest(repository, pullRequestId);
        PageRequest pageRequest = PageUtils.newRequest((int)start, (int)limit);
        if (contentsOnly) {
            response.setHeader("Cache-Control", "no-cache, no-transform");
            Page changesetPage = this.pullRequestService.getChangesets(repository.getId().intValue(), pullRequestId, pageRequest);
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(COMMIT_LIST_FRAGMENT).putRepository(repository).putPullRequest(pullRequest).put("changesetPage", (Object)changesetPage)).build();
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).putRepository(repository).putPullRequest(pullRequest).put("maxChanges", (Object)this.maxChanges)).put("startingTabKey", (Object)COMMITS_KEY)).build();
    }

    @RequestMapping(value={"/{pullRequestId}/commits"}, method={RequestMethod.GET}, params={"contents"})
    public ModelAndView getPullRequestCommitsContents(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit, HttpServletResponse response) {
        return this.viewPullRequestCommits(projectKey, repoSlug, pullRequestId, start, limit, true, response);
    }

    @RequestMapping(value={"/{pullRequestId}/commits/{changesetId}"}, method={RequestMethod.GET})
    public RedirectView viewPullRequestChangeset(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, @PathVariable(value="changesetId") String changesetId) {
        Repository toRepository = this.getRepository(projectKey, repoSlug);
        PullRequest pullRequest = this.getPullRequest(toRepository, pullRequestId);
        if (pullRequest.isCrossRepository()) {
            Repository fromRepository = pullRequest.getFromRef().getRepository();
            if (this.permissionService.hasRepositoryPermission(fromRepository, Permission.REPO_READ)) {
                return new RedirectView(this.navBuilder.repo(fromRepository).changeset(changesetId).buildRelative());
            }
            this.pullRequestService.ensureUpToDate(pullRequest);
        }
        return new RedirectView(this.navBuilder.repo(toRepository).changeset(changesetId).buildRelative());
    }

    @RequestMapping(value={"/{pullRequestId}/diff"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestDiff(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        PullRequest pullRequest = this.getPullRequest(repository, pullRequestId);
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).putRepository(repository).putPullRequest(pullRequest).put("maxChanges", (Object)this.maxChanges)).put("relevantContextLines", (Object)this.relevantContextLines)).put("startingTabKey", (Object)DIFF_KEY)).build();
    }

    @RequestMapping(value={"/{pullRequestId}"}, method={RequestMethod.GET}, params={"unwatch"})
    public ModelAndView unwatch(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, RedirectAttributes redirectAttributes) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        redirectAttributes.addFlashAttribute("unwatched", (Object)this.pullRequestService.unwatch(repository.getId().intValue(), pullRequestId));
        return this.viewPullRequest(projectKey, repoSlug, pullRequestId);
    }

    private PullRequest getPullRequest(Repository repository, long pullRequestId) {
        PullRequest pullRequest = this.pullRequestService.getById(repository.getId().intValue(), pullRequestId);
        if (pullRequest == null) {
            throw this.newNoSuchPullRequestException(repository, pullRequestId);
        }
        return pullRequest;
    }

    private PullRequestState getPullRequestState(String state) {
        try {
            return StringUtils.isEmpty((String)state) ? PullRequestState.OPEN : PullRequestState.valueOf((String)state.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return PullRequestState.OPEN;
        }
    }

    private PullRequestDirection getPullRequestDirection(String direction) {
        try {
            return StringUtils.isEmpty((String)direction) ? PullRequestDirection.INCOMING : PullRequestDirection.valueOf((String)direction.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return PullRequestDirection.INCOMING;
        }
    }

    private Ref resolveRefOrFail(Repository repoistory, String objectId) {
        Ref ref = this.metadataService.resolveRef(repoistory, objectId);
        if (ref == null) {
            throw new NoSuchChangesetException(this.i18nService.createKeyedMessage("stash.web.pullrequest.changesetnotfound", new Object[]{repoistory.getName(), objectId}), objectId);
        }
        return ref;
    }

    static /* synthetic */ UserService access$000(PullRequestController x0) {
        return x0.userService;
    }
}

