/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.locale;

import com.atlassian.fugue.Pair;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.web.locale.UserLocaleWebUtils;
import com.atlassian.stash.ui.ContextualFormFragment;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.view.TemplateRenderingException;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLocaleFormFragment
implements ContextualFormFragment {
    private static final String FIELD_LOCALE = "locale";
    private static final String LOCALE_TEMPLATE = "stash.feature.locale.field";
    private final InternalLanguageService languageService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    protected AbstractLocaleFormFragment(InternalLanguageService languageService, SoyTemplateRenderer soyTemplateRenderer) {
        this.languageService = languageService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected abstract Pair<Locale, List<Map<String, Object>>> load(Map<String, Object> var1);

    protected abstract void save(Map<String, Object> var1, Locale var2);

    public void doView(Appendable appendable, Map<String, Object> context) throws IOException {
        Pair data = this.load(context);
        try {
            this.soyTemplateRenderer.render(appendable, "com.atlassian.stash.stash-web-plugin:server-soy-templates", LOCALE_TEMPLATE, (Map)ImmutableMap.of((Object)"languages", (Object)Iterables.concat((Iterable)((Iterable)data.right()), (Iterable)UserLocaleWebUtils.toSoy((Iterable)this.languageService.getLanguages(), (String)((Locale)data.left()).toString())), (Object)"errors", (Object)Objects.firstNonNull((Object)context.get("errors"), Collections.emptyMap())));
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render stash.feature.locale.field", (Throwable)e);
        }
    }

    public void validate(Map<String, String[]> requestParams, ValidationErrors errors, Map<String, Object> context) {
        try {
            this.getLocale(requestParams);
        }
        catch (IllegalArgumentException e) {
            errors.addFieldError(FIELD_LOCALE, e.getMessage());
        }
    }

    public void doError(Appendable appendable, Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors, Map<String, Object> context) throws IOException {
        this.doView(appendable, (Map)ImmutableMap.builder().putAll(context).put((Object)"errors", fieldErrors).build());
    }

    public void execute(Map<String, String[]> requestParams, Map<String, Object> context) {
        this.save(context, this.getLocale(requestParams));
    }

    protected Locale getLocale(Map<String, String[]> requestParams) {
        String[] locale = requestParams.get(FIELD_LOCALE);
        return locale.length > 0 ? LocaleUtils.toLocale((String)StringUtils.trimToNull((String)locale[0])) : null;
    }
}

