/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.license.LicenseService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class GlobalFooterContextProvider
implements ContextProvider {
    public static final String PRODUCT_LINK = "http://www.atlassian.com/software/" + Product.NAME.toLowerCase() + "/";
    private final BuildInfo buildInfo;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final WebResourceIntegration webResourceIntegration;

    public GlobalFooterContextProvider(BuildInfo buildInfo, I18nService i18nService, LicenseService licenseService, WebResourceIntegration webResourceIntegration) {
        this.buildInfo = buildInfo;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.webResourceIntegration = webResourceIntegration;
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        StashLicense license = this.licenseService.get();
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"buildNumber", (Object)this.buildInfo.getBuildNumber()).put((Object)"systemBuildNumber", (Object)this.webResourceIntegration.getSystemBuildNumber()).put((Object)"buildVersion", (Object)this.buildInfo.getBuildVersion()).put((Object)"displayHash", (Object)this.buildInfo.getDisplayCommitHash()).put((Object)"hash", (Object)this.buildInfo.getCommitHash()).put((Object)"i18nService", (Object)this.i18nService).put((Object)"productName", (Object)Product.FULL_NAME).put((Object)"productUrl", (Object)PRODUCT_LINK).put((Object)"unlicensed", (Object)(license == null ? 1 : 0));
        if (license != null) {
            builder.put((Object)"license", (Object)license);
        }
        return builder.build();
    }
}

