/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.impl.StaticPlugin;
import com.atlassian.stash.util.DevModeUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class CachePurgeFilter
extends OncePerRequestFilter {
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;

    public CachePurgeFilter(PluginAccessor pluginAccessor, PluginController pluginController) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (DevModeUtils.isEnabled() && CachePurgeFilter.isShiftReload((HttpServletRequest)request) && CachePurgeFilter.isPageRequest((HttpServletRequest)request)) {
            this.reload();
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void reload() throws IOException {
        for (Plugin plugin : this.pluginAccessor.getEnabledPlugins()) {
            if (!(plugin instanceof StaticPlugin)) continue;
            this.pluginController.disablePlugin(plugin.getKey());
            this.pluginController.enablePlugins(new String[]{plugin.getKey()});
        }
    }

    private static boolean isPageRequest(HttpServletRequest httpRequest) {
        return !StringUtils.endsWith((String)httpRequest.getPathInfo(), (String)".png");
    }

    private static boolean isShiftReload(HttpServletRequest req) {
        return "GET".equals(req.getMethod()) && StringUtils.indexOf((String)req.getHeader("X-Requested-With"), (String)"XMLHttpRequest") == -1 && ("no-cache".equals(req.getHeader("Pragma")) || StringUtils.indexOf((String)req.getHeader("User-Agent"), (String)"MSIE") != -1) && "no-cache".equals(req.getHeader("Cache-Control"));
    }
}

