/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.context;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextCleanupListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(ContextCleanupListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.cleanHazelcast();
        this.cleanHttpClient();
        this.cleanJdbc();
    }

    private void cleanHazelcast() {
        for (HazelcastInstance instance : Hazelcast.getAllHazelcastInstances()) {
            log.debug("Shutting down Hazelcast instance: {}", (Object)instance.getName());
            try {
                instance.shutdown();
                log.trace("Shut down Hazelcast instance: {}", (Object)instance.getName());
            }
            catch (Exception e) {
                log.warn("Failed to shutdown Hazelcast instance: {}", (Object)instance.getName());
            }
        }
    }

    private void cleanHttpClient() {
        MultiThreadedHttpConnectionManager.shutdownAll();
    }

    private void cleanJdbc() {
        ClassLoader webClassLoader = this.getClass().getClassLoader();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            Class<?> driverClass = driver.getClass();
            String driverName = driverClass.getName();
            if (driverClass.getClassLoader() == webClassLoader) {
                log.debug("Unregistering JDBC driver: {}", (Object)driverName);
                try {
                    DriverManager.deregisterDriver(driver);
                    log.trace("Unregistered JDBC driver: {}", (Object)driverName);
                }
                catch (SQLException e) {
                    log.warn("Failed to unregister JDBC driver: " + driverName, (Throwable)e);
                }
                continue;
            }
            log.debug("Not unregistering JDBC driver: {}; it belongs to a different ClassLoader", (Object)driverName);
        }
    }
}

