/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.attach;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.attach.AttachmentService;
import com.atlassian.stash.internal.attach.AttachmentSupplier;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.attach.AttachmentController;
import com.atlassian.stash.internal.web.attach.AttachmentForm;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.util.DownloadHeaderHelper;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.PermissionService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/attachments"})
public class AttachmentController
extends RepositoryControllerSupport {
    private static final Function<ServiceException, RestAttachment> EXCEPTION_TO_ATTACHMENT = new /* Unavailable Anonymous Inner Class!! */;
    private final AttachmentService attachmentService;
    private final DownloadHeaderHelper downloadHeaderHelper;
    private final NavBuilder navBuilder;

    @Autowired
    public AttachmentController(I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, RepositoryMetadataService metadataService, PermissionService permissionService, AttachmentService attachmentService, DownloadHeaderHelper downloadHeaderHelper, NavBuilder navBuilder) {
        super(i18nService, projectService, repositoryService, metadataService, permissionService);
        this.attachmentService = attachmentService;
        this.downloadHeaderHelper = downloadHeaderHelper;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{token}/{attachmentName}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="token") String token, @PathVariable(value="attachmentName") String attachmentName) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.attachmentService.delete(repository, AttachmentController.toId((String)token, (String)attachmentName));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{token}/{attachmentName}"})
    public void retrieve(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="token") String token, @PathVariable(value="attachmentName") String attachmentName, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletResponse response) throws IOException {
        Repository repository = this.getRepository(projectKey, repoSlug);
        AttachmentSupplier supplier = this.attachmentService.read(repository, AttachmentController.toId((String)token, (String)attachmentName));
        ByteStreams.copy((InputSupplier)new /* Unavailable Anonymous Inner Class!! */, (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    @IgnoresXsrf
    @RequestMapping(consumes={"multipart/form-data"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> save(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, AttachmentForm attachments) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        List ids = this.attachmentService.saveAll(repository, attachments.toSuppliers());
        NavBuilder.RepoAttachments attachmentsNav = this.navBuilder.repo(repository).attachments();
        3 transform = new /* Unavailable Anonymous Inner Class!! */;
        return new ResponseEntity((Object)new RestAttachments(Lists.transform((List)ids, (Function)transform)), HttpStatus.CREATED);
    }

    private static String toId(String token, String attachmentName) {
        return token + "/" + attachmentName;
    }

    static /* synthetic */ DownloadHeaderHelper access$000(AttachmentController x0) {
        return x0.downloadHeaderHelper;
    }

    static /* synthetic */ Function access$100() {
        return EXCEPTION_TO_ATTACHMENT;
    }
}

