/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.exception.NoDefaultBranchException;
import com.atlassian.stash.exception.NoSuchProjectException;
import com.atlassian.stash.exception.RequestCanceledException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.hook.repository.RepositoryHookService;
import com.atlassian.stash.hook.repository.RepositoryHookType;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.attach.AttachmentService;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.admin.ForkForm;
import com.atlassian.stash.internal.web.admin.RepositoryForm;
import com.atlassian.stash.internal.web.repos.ViewRef;
import com.atlassian.stash.internal.web.repos.ViewRefType;
import com.atlassian.stash.internal.web.repos.ViewRefTypeHelper;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.FilteredErrors;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.atlassian.stash.internal.web.util.StashWebErrorUtils;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryCreateRequest;
import com.atlassian.stash.repository.RepositoryForkRequest;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.repository.RepositoryUpdateRequest;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.ui.PluginFormFragments;
import com.atlassian.stash.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/projects/{projectKey}/repos"})
public class RepositoryAdminController
extends RepositoryControllerSupport {
    private static final String PAGE_CREATE = "stash.page.createRepo";
    private static final String PAGE_FORK = "stash.page.forkRepo";
    private static final String PAGE_GENERAL_SETTINGS = "stash.page.repositoryGeneralSettings";
    private static final String PAGE_HOOK_SETTINGS = "stash.page.repositoryHookSettings";
    private static final String PAGE_PULL_REQUEST_SETTINGS = "stash.page.repositoryPullRequestSettings";
    static final String FRAGS_FORK = "stash.page.repository.fork";
    static final String FRAGS_GENERAL_SETTINGS = "stash.page.repository.settings.general";
    static final String FRAGS_PULL_REQUEST_SETTINGS = "stash.page.repository.settings.pullRequests";
    private final AttachmentService attachmentService;
    private final StashAuthenticationContext authenticationContext;
    private final FeatureManager featureManager;
    private final PluginFormFragmentsFactory fragmentsFactory;
    private final RepositoryHookService hookService;
    private final NavBuilder navBuilder;
    private final ApplicationPropertiesService propertiesService;
    private final ViewRefTypeHelper viewRefTypeHelper;

    @Autowired
    public RepositoryAdminController(I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, RepositoryMetadataService metadataService, PermissionService permissionService, AttachmentService attachmentService, StashAuthenticationContext authenticationContext, FeatureManager featureManager, PluginFormFragmentsFactory fragmentsFactory, RepositoryHookService hookService, NavBuilder navBuilder, ApplicationPropertiesService propertiesService, ViewRefTypeHelper viewRefTypeHelper) {
        super(i18nService, projectService, repositoryService, metadataService, permissionService);
        this.attachmentService = attachmentService;
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.fragmentsFactory = fragmentsFactory;
        this.hookService = hookService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.viewRefTypeHelper = viewRefTypeHelper;
    }

    @RequestMapping(params={"create"}, method={RequestMethod.POST})
    public ModelAndView createRepository(@PathVariable(value="projectKey") String projectKey, @Valid RepositoryForm form, Errors errors) {
        errors = RepositoryAdminController.filterErrors((Errors)errors);
        Project project = this.getProject(projectKey);
        ArrayList detailedErrors = Lists.newArrayList();
        if (!errors.hasErrors()) {
            try {
                RepositoryCreateRequest request = ((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().forkable(form.isForkable())).project(project).name(form.getName())).scmId(StringUtils.defaultIfBlank((String)form.getScmId(), (String)"git")).build();
                Repository repository = this.repositoryService.create(request);
                return new ModelAndView((View)new RedirectView(this.navBuilder.project(projectKey).repo(repository.getSlug()).buildRelNoContext(), true));
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.createRepo").putProject(project).putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).put("repositoryForm", (Object)form)).build();
    }

    @RequestMapping(params={"create"}, method={RequestMethod.GET})
    public ModelAndView createRepositoryView(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return new StashSoyResponseBuilder("stash.page.createRepo").putProject(project).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("stash.web.repository.create.accessdenied", new Object[]{project.getName()}));
    }

    @RequestMapping(value={"{repoSlug}/settings"}, method={RequestMethod.GET})
    public ModelAndView getSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.repository.edit.accessdenied", new Object[]{repository.getName()}));
        }
        return this.createSettingsPageBuilder(repository, new RepositoryForm(repository, this.getDefaultBranchIfAvailable(repository))).build();
    }

    @RequestMapping(value={"{repoSlug}/settings"}, method={RequestMethod.POST})
    public ModelAndView updateSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @Valid RepositoryForm repositoryForm, Errors errors, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        errors = RepositoryAdminController.filterErrors((Errors)errors);
        Repository repository = this.getRepository(projectKey, repoSlug);
        PluginValidationErrors pluginErrors = new PluginValidationErrors(errors);
        PluginFormFragments fragments = this.fragmentsFactory.forKey("stash.page.repository.settings.general", this.prepareSettingsContext(repository));
        fragments.validate(request.getParameterMap(), (ValidationErrors)pluginErrors);
        if (!pluginErrors.hasErrors() && !StringUtils.isBlank((String)repositoryForm.getDefaultBranchId())) {
            try {
                this.metadataService.setDefaultBranch(repository, repositoryForm.getDefaultBranchId().trim());
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (UnsupportedOperationException e) {
                this.log.warn("{}: Setting the default branch is not supported", (Object)repository, (Object)e);
            }
        }
        ArrayList detailedErrors = Lists.newArrayList();
        if (!pluginErrors.hasErrors()) {
            try {
                repository = this.repositoryService.update(((RepositoryUpdateRequest.Builder)((RepositoryUpdateRequest.Builder)new RepositoryUpdateRequest.Builder(repository).forkable(repositoryForm.isForkable())).name(repositoryForm.getName())).build());
                fragments.execute(request.getParameterMap());
                redirectAttributes.addFlashAttribute("isEditSuccess", (Object)true);
                return new ModelAndView("redirect:" + this.navBuilder.project(repository.getProject()).repo(repository).settings().buildRelNoContext());
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
        }
        repositoryForm.setDefaultBranch(this.getDefaultBranchIfAvailable(repository));
        return ((StashSoyResponseBuilder)this.createSettingsPageBuilder(repository, repositoryForm).putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).put("pluginFieldsContent", (Object)fragments.getErrorHtml(request.getParameterMap(), pluginErrors.getFieldErrors()))).build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public RedirectView repositoryList(@PathVariable(value="projectKey") String projectKey) {
        return new RedirectView(this.navBuilder.project(projectKey).buildRelNoContext(), true);
    }

    @RequestMapping(value={"{repoSlug}/settings/hooks"})
    public ModelAndView getHooks(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        Page preReceiveHookPage = this.hookService.findByType(repository, RepositoryHookType.PRE_RECEIVE, PageUtils.newRequest((int)0, (int)25));
        Page postReceiveHookPage = this.hookService.findByType(repository, RepositoryHookType.POST_RECEIVE, PageUtils.newRequest((int)0, (int)25));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.repositoryHookSettings").putRepository(repository).put("preReceiveHookPage", (Object)preReceiveHookPage)).put("postReceiveHookPage", (Object)postReceiveHookPage)).build();
    }

    @RequestMapping(value={"{repoSlug}/settings/pull-requests"})
    public ModelAndView getPullRequestSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.checkCanEditPullRequestSettings(repository);
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.repositoryPullRequestSettings").putRepository(repository).put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey("stash.page.repository.settings.pullRequests", this.prepareSettingsContext(repository)).getViewHtml())).build();
    }

    @RequestMapping(value={"{repoSlug}/settings/pull-requests"}, method={RequestMethod.POST})
    public ModelAndView updatePullRequestSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.checkCanEditPullRequestSettings(repository);
        PluginFormFragments fragments = this.fragmentsFactory.forKey("stash.page.repository.settings.pullRequests", this.prepareSettingsContext(repository));
        PluginValidationErrors pluginValidationErrors = new PluginValidationErrors(null);
        fragments.validate(request.getParameterMap(), (ValidationErrors)pluginValidationErrors);
        if (pluginValidationErrors.hasFieldErrors()) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.repositoryPullRequestSettings").putRepository(repository).put("pluginFieldsContent", (Object)fragments.getErrorHtml(request.getParameterMap(), pluginValidationErrors.getFieldErrors()))).build();
        }
        fragments.execute(request.getParameterMap());
        redirectAttributes.addFlashAttribute("isEditSuccess", (Object)true);
        return new ModelAndView("redirect:" + this.navBuilder.repo(repository).settings().pullRequests().buildRelNoContext());
    }

    @RequestMapping(value={"{repoSlug}"}, params={"fork"}, method={RequestMethod.GET})
    public ModelAndView forkRepositoryView(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.repository.fork.accessdenied", new Object[0]));
        }
        Repository repository = this.getRepository(projectKey, repoSlug);
        PersonalProject personalProject = this.projectService.getPersonalProject();
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.forkRepo").putRepository(repository).put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey("stash.page.repository.fork", this.prepareForkContext(repository, null)).getViewHtml());
        if (this.featureManager.isEnabled(Feature.PERSONAL_REPOS)) {
            builder.put("personalProject", (Object)personalProject);
        }
        return builder.build();
    }

    @RequestMapping(value={"{repoSlug}"}, params={"fork"}, method={RequestMethod.POST})
    public ModelAndView forkRepository(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @Valid ForkForm form, Errors errors, HttpServletRequest request) {
        Repository upstream = this.getRepository(projectKey, repoSlug);
        ArrayList detailedErrors = Lists.newArrayList();
        Project toProject = null;
        PluginFormFragments fragments = this.fragmentsFactory.forKey("stash.page.repository.fork", this.prepareForkContext(upstream, null));
        PluginValidationErrors pluginValidationErrors = new PluginValidationErrors(null);
        fragments.validate(request.getParameterMap(), (ValidationErrors)pluginValidationErrors);
        if (!pluginValidationErrors.hasFieldErrors() && !errors.hasErrors()) {
            try {
                toProject = this.getProject(form.getToProjectId());
                RepositoryForkRequest.Builder requestBuilder = ((RepositoryForkRequest.Builder)new RepositoryForkRequest.Builder(upstream).forkable(form.isForkable())).name(form.getName()).project(toProject);
                Repository fork = this.repositoryService.fork(requestBuilder.build());
                fragments = this.fragmentsFactory.forKey("stash.page.repository.fork", this.prepareForkContext(upstream, fork));
                fragments.execute(request.getParameterMap());
                return new ModelAndView((View)new RedirectView(this.navBuilder.project(fork.getProject().getKey()).repo(fork.getSlug()).buildRelNoContext(), true));
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (NoSuchProjectException e) {
                errors.rejectValue("toProjectId", e.getMessageKey(), e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        PersonalProject personalProject = this.projectService.getPersonalProject();
        StashSoyResponseBuilder builder = ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.forkRepo").putRepository(upstream).put("personalProject", (Object)personalProject)).put("pluginFieldsContent", (Object)fragments.getErrorHtml(request.getParameterMap(), pluginValidationErrors.getFieldErrors()))).put("forkForm", (Object)form)).putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors);
        if (toProject != null) {
            builder.put("toProject", (Object)toProject);
        }
        return builder.build();
    }

    @ResponseBody
    @RequestMapping(value={"{repoSlug}/sizes"}, method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, Long> getSizes(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.checkCanEditPullRequestSettings(repository);
        return ImmutableMap.of((Object)"repository", (Object)this.repositoryService.getSize(repository), (Object)"attachments", (Object)this.attachmentService.getSize(repository));
    }

    private StashSoyResponseBuilder createSettingsPageBuilder(Repository repository, RepositoryForm repositoryForm) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.repositoryGeneralSettings").putRepository(repository).put("repositoryForm", (Object)repositoryForm)).put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey("stash.page.repository.settings.general", this.prepareSettingsContext(repository)).getViewHtml());
        if (this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            builder.put("repositoryLocation", (Object)this.propertiesService.getRepositoryDir(repository).getAbsolutePath());
        }
        return builder;
    }

    private ViewRef getDefaultBranchIfAvailable(Repository repository) {
        if (repository.getState() != Repository.State.AVAILABLE) {
            this.log.warn("Failed to resolve default branch. state={}", (Object)repository.getState());
            return null;
        }
        try {
            Branch branch = this.metadataService.getDefaultBranch(repository);
            return new ViewRef(branch.getId(), branch.getDisplayId(), branch.getIsDefault(), this.viewRefTypeHelper.getViewRefType(ViewRefType.BRANCH), branch.getLatestChangeset());
        }
        catch (NoDefaultBranchException e) {
            this.log.info("Failed to resolve default branch. Cause: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Map<String, Object> prepareForkContext(Repository upstream, Repository fork) {
        HashMap context = Maps.newHashMap();
        context.put("upstream", upstream);
        if (fork != null) {
            context.put("fork", fork);
        }
        return context;
    }

    private Map<String, Object> prepareSettingsContext(Repository repository) {
        HashMap context = Maps.newHashMap();
        context.put("repository", repository);
        return context;
    }

    private void checkCanEditPullRequestSettings(Repository repository) {
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.repository.settings.pull.request", new Object[]{repository.getProject().getName(), repository.getName()}));
        }
    }

    private static Errors filterErrors(Errors errors) {
        return new FilteredErrors(errors, new String[]{"slug", "scmId"});
    }
}

