/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.RequestCanceledException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.admin.ProjectForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.internal.web.util.StashWebErrorUtils;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectCreateRequest;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.project.ProjectUpdateRequest;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.PermissionValidationService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/projects"})
public class ProjectAdminController
extends ControllerSupport {
    public static final String PROJECT_CREATE = "stash.page.createProject";
    public static final String PROJECT_EDIT_SETTINGS = "stash.project.projectSettings";
    public static final String PROJECT_LIST = "stash.page.projectList";
    private final InternalAvatarService avatarService;
    private final NavBuilder navBuilder;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final InternalProjectService projectService;
    private final RepositoryService repositoryService;

    @Autowired
    public ProjectAdminController(InternalAvatarService avatarService, I18nService i18nService, NavBuilder navBuilder, PermissionService permissionService, PermissionValidationService permissionValidationService, InternalProjectService projectService, RepositoryService repositoryService) {
        super(i18nService);
        this.avatarService = avatarService;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    @RequestMapping(params={"create"}, method={RequestMethod.POST})
    public ModelAndView createProject(@Valid ProjectForm form, Errors errors) {
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(PROJECT_CREATE);
        ArrayList detailedErrors = Lists.newArrayList();
        if (!errors.hasErrors()) {
            try {
                Project project = this.projectService.create(((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)new ProjectCreateRequest.Builder().key(form.getKey())).name(form.getName())).description(form.getDescription())).avatarUri(form.getAvatar()).build());
                return new ModelAndView((View)new RedirectView(this.navBuilder.project(project.getKey()).buildRelNoContext(), true));
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        return ((StashSoyResponseBuilder)responseBuilder.putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).put("projectForm", (Object)form)).build();
    }

    @RequestMapping(params={"create"}, method={RequestMethod.GET})
    public ModelAndView createProjectView() {
        if (this.permissionService.hasGlobalPermission(Permission.PROJECT_CREATE)) {
            return new StashSoyResponseBuilder(PROJECT_CREATE).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("stash.web.project.create.accessdenied", new Object[0]));
    }

    @RequestMapping(value={"{projectKey}"}, params={"delete"}, method={RequestMethod.POST})
    public RedirectView deleteProject(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null || !this.projectService.delete(project)) {
            throw this.newNoSuchProjectException(projectKey);
        }
        return new RedirectView(this.navBuilder.allProjects().buildRelNoContext(), true);
    }

    @RequestMapping(value={"{projectKey}/settings"}, method={RequestMethod.GET})
    public ModelAndView editProject(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        if (project.getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("stash.web.project.edit.personalunmodifiable", new Object[0]));
        }
        if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return new StashSoyResponseBuilder(PROJECT_EDIT_SETTINGS).putProject(project).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("stash.web.project.edit.accessdenied", new Object[]{project.getName()}));
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getProjects(@RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Page projects = this.projectService.findAll((PageRequest)new PageRequestImpl(start, limit));
        this.validatePage(projects);
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(PROJECT_LIST).put("projectPage", (Object)projects)).build();
    }

    @RequestMapping(value={"{projectKey}"}, method={RequestMethod.GET})
    public ModelAndView getProject(@PathVariable(value="projectKey") String projectKey, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            if (this.projectService.isPersonalProject(projectKey)) {
                project = this.projectService.getPersonalProject();
            } else {
                throw this.newNoSuchProjectException(projectKey);
            }
        }
        if (project.getType() == ProjectType.PERSONAL) {
            return new ModelAndView("redirect:" + this.navBuilder.userBySlug(InternalPersonalProject.getPersonalProjectOwner((String)projectKey)).buildRelNoContext());
        }
        Page repositoryPage = this.repositoryService.findByProjectKey(project.getKey(), (PageRequest)new PageRequestImpl(start, limit));
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.project.projectOverview").putProject(project).put("repositoryPage", (Object)repositoryPage)).build();
    }

    @ExceptionHandler(value={NoSuchEntityException.class})
    public ModelAndView handleNoSuchProject(NoSuchEntityException exception) {
        return new ModelAndView("stash.errors.project404", "error", (Object)exception);
    }

    @RequestMapping(value={"{projectKey}/avatar.png"}, method={RequestMethod.GET}, produces={"image/png"})
    public void retrieveAvatar(@PathVariable(value="projectKey") String projectKey, @RequestParam(defaultValue="256", value="s") int size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Project project;
        try {
            project = this.projectService.getByKey(projectKey);
        }
        catch (AuthorisationException e) {
            project = null;
        }
        CacheableAvatarSupplier supplier = project == null ? this.avatarService.getProjectDefault(size) : this.projectService.getAvatar(project.getId().intValue(), size);
        this.streamAvatar(supplier, request, response);
    }

    @RequestMapping(value={"{projectKey}/settings"}, method={RequestMethod.POST})
    public ModelAndView updateProject(@PathVariable(value="projectKey") String projectKey, @Valid ProjectForm form, Errors errors, RedirectAttributes redirectAttributes) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(PROJECT_EDIT_SETTINGS);
        ArrayList detailedErrors = Lists.newArrayList();
        if (!errors.hasErrors()) {
            try {
                project = this.projectService.update(((ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)new ProjectUpdateRequest.Builder(project).key(form.getKey())).name(form.getName())).description(form.getDescription())).build());
                if (form.hasAvatar()) {
                    this.projectService.updateAvatar(project.getId().intValue(), form.getAvatar());
                }
                redirectAttributes.addFlashAttribute("isEditSuccess", (Object)true);
                return new ModelAndView("redirect:" + this.navBuilder.project(project.getKey()).settings().buildRelNoContext());
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        return ((StashSoyResponseBuilder)responseBuilder.putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).putProject(project).put("projectForm", (Object)form)).build();
    }

    private void validatePage(Page<?> page) {
        if (page.getIsLastPage() && page.getSize() == 0 && page.getStart() == 0) {
            this.permissionValidationService.validateAuthenticated();
        }
    }
}

