/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.cluster.ClusterService;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.DbTypeBean;
import com.atlassian.stash.internal.db.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.internal.migration.MigrationService;
import com.atlassian.stash.internal.migration.MigrationValidationException;
import com.atlassian.stash.internal.web.admin.DbConfigForm;
import com.atlassian.stash.internal.web.admin.DbConfigurationController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.nav.NavBuilder;
import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Conventions;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/admin/db"})
public class DbConfigurationController
extends ControllerSupport {
    public static final String ATTR_LAST_MIGRATION_STATUS = Conventions.getQualifiedAttributeName(DbConfigurationController.class, (String)"lastMigrationStatus");
    static final String EDIT_DB_CONFIG_PAGE = "stash.page.admin.db.migrateConfig";
    static final String KEY_LAST_MIGRATION_SUCCESSFUL = "lastMigrationSuccessful";
    static final String VIEW_DB_CONFIG_PAGE = "stash.page.admin.db.viewConfig";
    private static final String DB_NAME_INTERNAL = "com.atlassian.stash.database.display.name.internal";
    private static final String DB_NAME_UNKNOWN = "com.atlassian.stash.database.display.name.unknown";
    private final ClusterService clusterService;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final MigrationService migrationService;
    private final NavBuilder navBuilder;
    private static final Function<DbType, String> TO_DISPLAY_NAME_KEY = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public DbConfigurationController(I18nService i18nService, ClusterService clusterService, DataSourceConfiguration dataSourceConfiguration, MigrationService migrationService, NavBuilder navBuilder) {
        super(i18nService);
        this.clusterService = clusterService;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.migrationService = migrationService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public ModelAndView testAndMigrateDbConfig(@Valid DbConfigForm dbConfigForm, Errors errors, HttpServletRequest request) {
        if (this.clusterService.isClustered()) {
            return this.redirectToViewDbConfig();
        }
        DbTypeBean selectedDbType = DbTypeBean.forKey((String)dbConfigForm.getType());
        StashSoyResponseBuilder responseBuilder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.admin.db.migrateConfig").put("dbConfigForm", (Object)dbConfigForm)).put("currentDbType", (Object)selectedDbType)).put("dbTypes", (Object)DbTypeBean.ALL);
        if (errors.hasErrors()) {
            return responseBuilder.putValidationErrors(errors).build();
        }
        String jdbcUrl = selectedDbType.generateUrl(dbConfigForm.getHostname(), dbConfigForm.getDatabase(), dbConfigForm.getPortAsInteger());
        SimpleDataSourceConfiguration configuration = new SimpleDataSourceConfiguration(selectedDbType.getDriverClassName(), jdbcUrl, dbConfigForm.getUsername(), dbConfigForm.getPassword());
        try {
            if (request.getParameter("test") == null) {
                this.migrationService.migrate((DataSourceConfiguration)configuration).registerCallback((MaintenanceCompletionCallback)new MigrationStatusCallback(request.getSession(), null));
                return new ModelAndView("redirect:/unavailable");
            }
            this.migrationService.validateConfiguration((DataSourceConfiguration)configuration);
            responseBuilder.put("testPassed", (Object)true);
        }
        catch (MigrationValidationException e) {
            responseBuilder.putFormErrors((ServiceException)((Object)e));
        }
        catch (ServiceException e) {
            responseBuilder.put("migrationException", (Object)e);
        }
        return responseBuilder.build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewDbConfig(HttpSession session) {
        String driverClassName = this.dataSourceConfiguration.getDriverClassName();
        boolean isInternal = driverClassName.startsWith("org.hsqldb");
        String displayNameKey = DbConfigurationController.getDatabaseDisplayNameKey((String)driverClassName, (boolean)isInternal);
        StashSoyResponseBuilder responseBuilder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.admin.db.viewConfig").put("displayNameKey", (Object)displayNameKey)).put("isInternal", (Object)isInternal)).put("isClustered", (Object)this.clusterService.isClustered())).put("jdbcUrl", (Object)this.dataSourceConfiguration.getUrl())).put("jdbcUsername", (Object)this.dataSourceConfiguration.getUser())).put("isJdbcPasswordSet", (Object)this.dataSourceConfiguration.isPasswordSet());
        Object lastMigrationStatus = session.getAttribute(ATTR_LAST_MIGRATION_STATUS);
        if (Boolean.TRUE.equals(lastMigrationStatus)) {
            session.removeAttribute(ATTR_LAST_MIGRATION_STATUS);
            responseBuilder.put("lastMigrationSuccessful", (Object)true);
        } else if (lastMigrationStatus instanceof Exception) {
            session.removeAttribute(ATTR_LAST_MIGRATION_STATUS);
            if (lastMigrationStatus instanceof MigrationException) {
                responseBuilder.put("migrationException", lastMigrationStatus);
            } else {
                responseBuilder.putFormErrors(new String[]{((Exception)lastMigrationStatus).getLocalizedMessage()});
            }
        }
        return responseBuilder.build();
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public ModelAndView viewEditDbConfigForm() {
        if (this.clusterService.isClustered()) {
            return this.redirectToViewDbConfig();
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.page.admin.db.migrateConfig").put("dbTypes", (Object)DbTypeBean.ALL)).put("currentDbType", (Object)DbTypeBean.DEFAULT)).build();
    }

    private ModelAndView redirectToViewDbConfig() {
        return new ModelAndView("redirect:" + this.navBuilder.admin().database().buildRelNoContext());
    }

    private static String getDatabaseDisplayNameKey(String driverClassName, boolean internal) {
        return internal ? "com.atlassian.stash.database.display.name.internal" : DbConfigurationController.getExternalDatabaseDisplayNameKey((String)driverClassName);
    }

    private static String getExternalDatabaseDisplayNameKey(String driverClassName) {
        return (String)DbType.forDriver((String)driverClassName).map(TO_DISPLAY_NAME_KEY).getOrElse((Object)"com.atlassian.stash.database.display.name.unknown");
    }
}

