/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.io.Resources;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/about"})
public class AboutController {
    public static final String AUTHOR_FILE = "/AUTHORS.txt";
    public static final String VIEW = "stash.page.about";
    private final ApplicationPropertiesService appPropService;
    private final ServletContextFactory servletContextFactory;

    @Autowired
    public AboutController(ApplicationPropertiesService appPropService, ServletContextFactory servletContextFactory) {
        this.appPropService = appPropService;
        this.servletContextFactory = servletContextFactory;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showAbout() throws MalformedURLException {
        boolean showLicenses = this.servletContextFactory.getServletContext().getResource("/static/page/about/lgpl.soy") != null;
        Set authors = this.retrieveAuthors();
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("authors", (Object)authors)).put("showLicenses", (Object)showLicenses)).put("copyrightStartYear", (Object)2012)).put("copyrightEndYear", (Object)this.calcEndCopyrightYear())).build();
    }

    private int calcEndCopyrightYear() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.appPropService.getBuildTimestamp());
        return cal.get(1);
    }

    private Set<String> retrieveAuthors() {
        TreeSet<String> authors;
        block15: {
            authors = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            try {
                String file = Resources.getResource((String)AUTHOR_FILE).getFile();
                if (!StringUtils.isNotEmpty((String)file)) break block15;
                try (FileReader reader = new FileReader(file);){
                    LineIterator iterator = IOUtils.lineIterator((Reader)reader);
                    while (iterator.hasNext()) {
                        String line = StringUtils.trimToEmpty((String)iterator.next());
                        if (line.length() <= 0 || line.charAt(0) == '#') continue;
                        authors.add(line);
                    }
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return authors;
    }
}

