/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.internal.spring.security.TwilightingRememberMeServices;
import com.atlassian.stash.request.RequestManager;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

public class TwilightingRememberMeServices
extends PersistentTokenBasedRememberMeServices {
    private static final Logger log = LoggerFactory.getLogger(TwilightingRememberMeServices.class);
    private final RequestManager requestManager;
    private final PersistentTokenRepository tokenRepository;
    private final long twilightDuration = TimeUnit.SECONDS.toMillis(60L);
    private final Map<String, Date> twilightedTokens;

    public TwilightingRememberMeServices(String key, RequestManager requestManager, PersistentTokenRepository tokenRepository, UserDetailsService userDetailsService) {
        super(key, userDetailsService, tokenRepository);
        this.requestManager = requestManager;
        this.tokenRepository = tokenRepository;
        this.twilightedTokens = Maps.newConcurrentMap();
    }

    @EventListener
    public void onUserDeleted(UserCleanupEvent event) {
        this.tokenRepository.removeUserTokens(event.getDeletedUser().getName());
    }

    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        PersistentRememberMeToken token;
        PersistentRememberMeToken persistentRememberMeToken = token = cookieTokens.length > 0 ? this.tokenRepository.getTokenForSeries(cookieTokens[0]) : null;
        if (token != null && this.isTwilighted(cookieTokens)) {
            log.trace("Using twilighted token for user [{}]", (Object)token.getUsername());
            return this.getUserDetailsService().loadUserByUsername(token.getUsername());
        }
        UserDetails details = super.processAutoLoginCookie(cookieTokens, request, response);
        if (details == null) {
            throw new UsernameNotFoundException("Could not find user " + token.getUsername());
        }
        log.trace("Twilighting token for user [{}]", (Object)details.getUsername());
        this.twilightToken(cookieTokens);
        return details;
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        1 wrapper = new /* Unavailable Anonymous Inner Class!! */;
        super.setCookie(tokens, maxAge, request, (HttpServletResponse)wrapper);
    }

    private boolean isTwilighted(String[] cookieTokens) {
        Date expiration = (Date)this.twilightedTokens.get(this.generateKey(cookieTokens));
        return expiration != null && expiration.after(new Date());
    }

    private String generateKey(String[] cookieTokens) {
        return cookieTokens[0] + ":" + cookieTokens[1] + ":" + this.requestManager.getRequestContext().getRemoteAddress();
    }

    private void twilightToken(String[] cookieTokens) {
        String key = this.generateKey(cookieTokens);
        this.twilightedTokens.put(key, new Date(System.currentTimeMillis() + this.twilightDuration));
        if (this.twilightedTokens.size() > 500) {
            Date now = new Date();
            Iterator it = this.twilightedTokens.values().iterator();
            int count = 0;
            while (it.hasNext()) {
                if (!((Date)it.next()).before(now)) continue;
                it.remove();
                ++count;
            }
            log.debug("Cleaning up twilighted tokens [{}] removed", (Object)count);
        }
    }
}

