/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.stash.auth.HttpAuthenticationContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.auth.HttpAuthenticationHandler;
import com.atlassian.stash.auth.HttpAuthenticationSuccessContext;
import com.atlassian.stash.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.stash.internal.auth.AuthenticationHelper;
import com.atlassian.stash.internal.auth.DefaultHttpAuthenticationContext;
import com.atlassian.stash.internal.spring.security.HttpAuthenticationContextToken;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.scm.AuthenticationState;
import com.atlassian.stash.user.AuthenticationException;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.web.filter.GenericFilterBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class StashAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(StashAuthenticationFilter.class);
    static final String BASIC_PREFIX = "Basic ";
    static final String KEY_USERNAME = "j_username";
    static final String KEY_PASSWORD = "j_password";
    static final String URL_SECURITY_CHECK = "j_stash_security_check";
    private final StashAuthenticationContext authenticationContext;
    private final HttpAuthenticationHandler authenticationHandler;
    private final AuthenticationHelper authenticationHelper;
    private final HttpAuthenticationFailureHandler authenticationFailureHandler;
    private final AuthenticationManager authenticationManager;
    private final HttpAuthenticationSuccessHandler authenticationSuccessHandler;
    private final String loginPageUrl;
    private final RememberMeServices rememberMeServices;

    public StashAuthenticationFilter(StashAuthenticationContext authenticationContext, HttpAuthenticationHandler authenticationHandler, AuthenticationHelper authenticationHelper, AuthenticationManager authenticationManager, HttpAuthenticationFailureHandler failureHandler, HttpAuthenticationSuccessHandler successHandler, RememberMeServices rememberMeServices, String loginPageUrl) {
        this.authenticationContext = (StashAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.authenticationHandler = (HttpAuthenticationHandler)Preconditions.checkNotNull((Object)authenticationHandler, (Object)"authenticationHandler");
        this.authenticationHelper = (AuthenticationHelper)Preconditions.checkNotNull((Object)authenticationHelper, (Object)"authenticationHelper");
        this.authenticationFailureHandler = (HttpAuthenticationFailureHandler)Preconditions.checkNotNull((Object)failureHandler, (Object)"failureHandler");
        this.authenticationManager = (AuthenticationManager)Preconditions.checkNotNull((Object)authenticationManager, (Object)"authenticationManager");
        this.authenticationSuccessHandler = (HttpAuthenticationSuccessHandler)Preconditions.checkNotNull((Object)successHandler, (Object)"successHandler");
        this.loginPageUrl = (String)Preconditions.checkNotNull((Object)loginPageUrl, (Object)"loginPageUrl");
        this.rememberMeServices = (RememberMeServices)Preconditions.checkNotNull((Object)rememberMeServices, (Object)"rememberMeServices");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block9: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            this.clearSecurityContextIfUrlIsSecurityCheck(request);
            DefaultHttpAuthenticationContext context = this.createContext(request, response, chain);
            InsufficientAuthenticationException authEx = null;
            try {
                if (context.isAuthenticated()) {
                    this.authenticationHandler.validateAuthentication((HttpAuthenticationContext)context);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            catch (AuthenticationException e) {
                log.debug("Authentication validation failed {}, logging out user", (Object)e.getMessage());
                SecurityContextHolder.clearContext();
                context.setAuthenticationState(AuthenticationState.NOT_AUTHENTICATED);
                authEx = new InsufficientAuthenticationException(e.getLocalizedMessage(), (Throwable)e);
            }
            if (this.shouldAuthenticate(context)) {
                try {
                    Authentication authentication = this.authenticationManager.authenticate((Authentication)new HttpAuthenticationContextToken(context));
                    this.onSuccess(authentication, context);
                }
                catch (ProviderNotFoundException e) {
                    if (authEx != null) {
                        this.onFailure(authEx, context);
                        break block9;
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (org.springframework.security.core.AuthenticationException e) {
                    this.onFailure(authEx == null ? e : authEx, context);
                }
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void clearSecurityContextIfUrlIsSecurityCheck(HttpServletRequest request) {
        if (StashAuthenticationFilter.isUrl((HttpServletRequest)request, (String)"j_stash_security_check")) {
            SecurityContextHolder.clearContext();
        }
    }

    private DefaultHttpAuthenticationContext createContext(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        String[] basicAuthTokens = StashAuthenticationFilter.extractBasicAuthentication((HttpServletRequest)request);
        DefaultHttpAuthenticationContext context = basicAuthTokens == null ? this.createContextFromQueryParameters(request, response, chain) : new DefaultHttpAuthenticationContext(request, response, chain, "basic", basicAuthTokens[0], (Object)basicAuthTokens[1]);
        if (this.authenticationContext.isAuthenticated()) {
            context.setAuthenticationState(AuthenticationState.AUTHENTICATED);
            context.setUser(this.authenticationContext.getCurrentUser());
        }
        return context;
    }

    private DefaultHttpAuthenticationContext createContextFromQueryParameters(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        String username = request.getParameter("j_username");
        String credentials = request.getParameter("j_password");
        return new DefaultHttpAuthenticationContext(request, response, chain, username != null ? "form" : "token", username, (Object)credentials);
    }

    private boolean isAlreadyFailed(HttpServletRequest request) {
        return this.authenticationHelper.isAuthenticationFailed(request);
    }

    private void onFailure(org.springframework.security.core.AuthenticationException e, DefaultHttpAuthenticationContext context) throws ServletException, IOException {
        log.trace("Authentication failed for user {} and method {} ({})", new Object[]{context.getUsername(), context.getMethod(), e.getMessage()});
        Throwable cause = e.getCause();
        context.onFailure(StashAuthenticationFilter.determineAuthenticationState((org.springframework.security.core.AuthenticationException)e), (AuthenticationException)((Object)StashAuthenticationFilter.maybeGetAs(AuthenticationException.class, (Object)cause)));
        if ("form".equals(context.getMethod())) {
            context.getRequest().getSession(true);
        }
        this.authenticationHelper.setAuthenticationException(context.getRequest(), e);
        this.authenticationHelper.setCachedUsername(context.getRequest(), context.getUsername());
        this.rememberMeServices.loginFail(context.getRequest(), context.getResponse());
        this.authenticationFailureHandler.onAuthenticationFailure((HttpAuthenticationFailureContext)context);
    }

    private void onSuccess(Authentication authentication, DefaultHttpAuthenticationContext context) throws ServletException, IOException {
        log.trace("Authentication succeeded for user {} and method {})", (Object)context.getUsername(), (Object)context.getMethod());
        SecurityContextHolder.getContext().setAuthentication(authentication);
        this.authenticationHelper.setAuthenticationException(context.getRequest(), null);
        StashUser user = null;
        if (authentication instanceof StashUserAuthenticationToken) {
            user = ((StashUserAuthenticationToken)authentication).getPrincipal();
        }
        context.onSuccess(user);
        this.rememberMeServices.loginSuccess(context.getRequest(), context.getResponse(), authentication);
        if (this.authenticationSuccessHandler.onAuthenticationSuccess((HttpAuthenticationSuccessContext)context)) {
            return;
        }
        context.getFilterChain().doFilter((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
    }

    private boolean shouldAuthenticate(DefaultHttpAuthenticationContext token) {
        HttpServletRequest request = token.getRequest();
        try (Timer timer = TimerUtils.start((String)(this.getClass().getCanonicalName() + ".requiresAuthentication"));){
            if ((StashAuthenticationFilter.isUrl((HttpServletRequest)request, (String)this.loginPageUrl) || request.getDispatcherType() == DispatcherType.ERROR) && this.isAlreadyFailed(request)) {
                boolean bl = false;
                return bl;
            }
            if (StashAuthenticationFilter.isUrl((HttpServletRequest)request, (String)"j_stash_security_check")) {
                boolean bl = true;
                return bl;
            }
            if ("basic".equals(token.getMethod())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = token.getAuthenticationState() != AuthenticationState.AUTHENTICATED;
            return bl;
        }
    }

    private static AuthenticationState determineAuthenticationState(org.springframework.security.core.AuthenticationException exception) {
        if (exception instanceof LockedException) {
            return AuthenticationState.CAPTCHA_REQUIRED;
        }
        if (exception instanceof DisabledException) {
            return AuthenticationState.UNLICENSED;
        }
        return AuthenticationState.NOT_AUTHENTICATED;
    }

    private static String[] extractBasicAuthentication(HttpServletRequest request) {
        byte[] tokenBytes;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Basic ")) {
            return null;
        }
        log.trace("Basic authentication header found");
        try {
            tokenBytes = Base64.decode((byte[])authorization.substring("Basic ".length()).getBytes(Charsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            log.debug("Unable to decode basic authentication header; it will be ignored", (Throwable)e);
            return null;
        }
        String token = new String(tokenBytes, Charsets.UTF_8);
        int index = token.indexOf(":");
        if (index == -1) {
            log.debug("Invalid basic authentication header (no ':' separator detected); it will be ignored");
            return null;
        }
        String username = token.substring(0, index);
        String credentials = token.substring(index + 1);
        log.trace("Found Basic authentication credentials for {}", (Object)username);
        return new String[]{username, credentials};
    }

    private static <T> T maybeGetAs(Class<T> clazz, Object value) {
        if (clazz != null && value != null && clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        return null;
    }

    private static boolean isUrl(HttpServletRequest request, String urlSuffix) {
        String uri = StringUtils.substringBefore((String)request.getRequestURI(), (String)";");
        return uri.endsWith(urlSuffix);
    }
}

