/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.scm.HttpScmRequestProvider;
import com.atlassian.stash.scm.ScmRequest;
import com.atlassian.stash.scm.ScmRequestCheckService;
import com.atlassian.stash.scm.http.HttpScmRequest;
import com.atlassian.stash.scm.http.RepositoryUrlFragment;
import com.atlassian.stash.util.RequestUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestHandler;

@Component(value="scmServlet")
public class ScmServlet
implements HttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ScmServlet.class);
    private final HttpScmRequestProvider httpScmRequestProvider;
    private final ScmRequestCheckService requestCheckService;
    private final RepositoryService repositoryService;
    private final NavBuilder navBuilder;
    private final I18nService i18nService;

    @Autowired
    public ScmServlet(HttpScmRequestProvider httpScmRequestProvider, ScmRequestCheckService requestCheckService, RepositoryService repositoryService, NavBuilder navBuilder, I18nService i18nService) {
        this.httpScmRequestProvider = httpScmRequestProvider;
        this.requestCheckService = requestCheckService;
        this.repositoryService = repositoryService;
        this.navBuilder = navBuilder;
        this.i18nService = i18nService;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpScmRequest requestHandler = this.httpScmRequestProvider.getHttpScmRequest(request, response);
        if (requestHandler != null) {
            if (!this.requestCheckService.checkActionAllowed((ScmRequest)requestHandler)) {
                return;
            }
            requestHandler.handleRequest();
        } else if (RequestUtils.isUserAgentBrowser((HttpServletRequest)request)) {
            Repository repository = null;
            RepositoryUrlFragment fragment = RepositoryUrlFragment.fromPathInfo((String)request.getPathInfo());
            if (fragment != null) {
                repository = this.repositoryService.getBySlug(fragment.getProjectKey(), fragment.getRepositorySlug());
            }
            if (repository != null) {
                response.sendRedirect(this.navBuilder.repo(repository).buildAbsolute());
            } else {
                response.sendRedirect(this.navBuilder.buildAbsolute());
            }
        } else {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.web.scm.invalidrequest", new Object[]{Product.NAME, RequestUtils.getRemoteHost((HttpServletRequest)request)});
            log.debug(message.getRootMessage());
            response.setStatus(501);
            response.getWriter().write(message.getLocalisedMessage());
        }
    }
}

