/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback.web;

import ch.qos.logback.core.joran.spi.JoranException;
import com.atlassian.stash.internal.logback.LogbackConfigurer;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogbackWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "logbackExposeWebAppRoot";

    private LogbackWebConfigurer() {
    }

    public static void initLogging(ServletContext servletContext) {
        String location;
        if (LogbackWebConfigurer.exposeWebAppRoot((ServletContext)servletContext)) {
            WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
        }
        if ((location = servletContext.getInitParameter("logbackConfigLocation")) != null) {
            try {
                if (!ResourceUtils.isUrl((String)location)) {
                    location = SystemPropertyUtils.resolvePlaceholders((String)location);
                    location = WebUtils.getRealPath((ServletContext)servletContext, (String)location);
                }
                servletContext.log("Initializing Logback from [" + location + "]");
                LogbackConfigurer.initLogging((String)location);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("Invalid 'logbackConfigLocation' parameter: " + ex.getMessage());
            }
            catch (JoranException e) {
                throw new RuntimeException("Unexpected error while configuring logback", e);
            }
        }
        try {
            Class<?> julBridge = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            Method install = ReflectionUtils.findMethod(julBridge, (String)"install");
            if (install != null) {
                servletContext.log("Installing JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)install, null);
            }
        }
        catch (ClassNotFoundException ignored) {
            servletContext.log("JUL to SLF4J bridge is not available on the classpath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogging(ServletContext servletContext) {
        try {
            Class<?> julBridge = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            Method uninstall = ReflectionUtils.findMethod(julBridge, (String)"uninstall");
            if (uninstall != null) {
                servletContext.log("Uninstalling JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)uninstall, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            servletContext.log("Shutting down Logback");
            LogbackConfigurer.shutdownLogging();
        }
        finally {
            if (LogbackWebConfigurer.exposeWebAppRoot((ServletContext)servletContext)) {
                WebUtils.removeWebAppRootSystemProperty((ServletContext)servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter("logbackExposeWebAppRoot");
        return exposeWebAppRootParam != null && Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

