/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class JohnsonServlet
extends HttpServlet {
    private static final String PAGE_FATAL_ERROR = "/fatal.jsp";
    private static final String PAGE_MAINTENANCE = "/mvc/maintenance";
    private static final String PAGE_STARTUP = "/system/startup";
    private static final String PAGE_SYSTEM_MAINTENANCE = "/mvc/maintenance/lock";
    private static final String LEVEL_MAINTENANCE = "maintenance";
    private static final String LEVEL_SYSTEM_MAINTENANCE = "system-maintenance";
    private static final List<String> EVENT_LEVELS = ImmutableList.builder().add((Object)"system-maintenance").add((Object)"maintenance").add((Object)"warning").add((Object)"error").add((Object)"fatal").build();
    private static final Map<String, String> LEVELS_TO_PAGES = ImmutableMap.builder().put((Object)"maintenance", (Object)"/mvc/maintenance").put((Object)"system-maintenance", (Object)"/mvc/maintenance/lock").build();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JohnsonEventContainer eventContainer = Johnson.getEventContainer((ServletContext)this.getServletContext());
        Collection events = eventContainer.getEvents();
        String highestEventLevel = JohnsonServlet.findHighestEventLevel((Collection)events);
        if (highestEventLevel == null) {
            if (LifecycleUtils.isStarting((ServletContext)this.getServletContext())) {
                request.getRequestDispatcher("/system/startup").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(request.getContextPath());
            }
        } else if (LEVELS_TO_PAGES.containsKey(highestEventLevel)) {
            request.getRequestDispatcher((String)LEVELS_TO_PAGES.get(highestEventLevel)).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            request.getRequestDispatcher("/fatal.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static String findHighestEventLevel(Collection<Event> events) {
        int i = -1;
        for (Event event : events) {
            int x = EVENT_LEVELS.indexOf(event.getLevel().getLevel());
            if (x <= i) continue;
            i = x;
        }
        return i == -1 ? null : (String)EVENT_LEVELS.get(i);
    }
}

