/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.FilteredPageImpl;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.TreeMap;

public class PageUtils {
    public static final int SUBPAGE_MULTIPLIER = 2;

    public static <T> Page<T> createPage(Iterable<T> elements, PageRequest request) {
        int size = Iterables.size(elements);
        boolean lastPage = size <= request.getLimit();
        int pageSize = lastPage ? size : request.getLimit();
        return new PageImpl(request, pageSize, Iterables.limit(elements, (int)pageSize), lastPage);
    }

    public static <T> Page<T> createPage(PageRequest request, Function<Integer, T> elementGenerator) {
        int index;
        Object element;
        ArrayList<Object> values = new ArrayList<Object>();
        int num = request.getLimit() + 1;
        for (int i = 0; i < num && (element = elementGenerator.apply((Object)(index = request.getStart() + i))) != null; ++i) {
            values.add(element);
        }
        return PageUtils.createPage(values, request);
    }

    public static <T> Page<T> filterPages(PageProvider<T> pageProvider, PageFilter<T> filter, PageRequest pageRequest) {
        TreeMap<Integer, T> results = new TreeMap<Integer, T>();
        int pageLimit = pageRequest.getLimit() + 1;
        PageRequestImpl internalRequest = new PageRequestImpl(pageRequest.getStart(), pageRequest.getLimit() * 2);
        do {
            Page<T> internalPage = pageProvider.get((PageRequest)internalRequest);
            int limit = pageLimit - results.size();
            if (limit > 0 && internalPage.getSize() > 0) {
                results.putAll(filter.apply(limit, internalPage));
            }
            internalRequest = internalPage.getNextPageRequest();
        } while (results.size() < pageLimit && internalRequest != null);
        int size = results.size();
        boolean lastPage = size <= pageRequest.getLimit();
        int finalPageSize = lastPage ? size : pageRequest.getLimit();
        return new FilteredPageImpl(pageRequest, finalPageSize, results, lastPage);
    }
}

