/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userUtils")
public class UserUtils {
    public static final String NAME_MATCHING_REGEX = "(\\b|^|[^\\p{L}\\p{N}])";
    private final CrowdService crowdService;

    @Autowired
    public UserUtils(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public User getBackingCrowdUser(StashUser stashUser) {
        User crowdUser = InternalConverter.convertToInternalUser(stashUser).getBackingCrowdUser();
        if (crowdUser == null) {
            crowdUser = this.crowdService.getUser(stashUser.getName());
        }
        return crowdUser;
    }

    public Page<? extends StashUser> getCrowdBackedPage(Page<? extends StashUser> page) {
        ArrayList<InternalStashUser> values = new ArrayList<InternalStashUser>();
        for (StashUser user : page.getValues()) {
            values.add(InternalConverter.convertToInternalUser(user).copy().crowdUser(this.getBackingCrowdUser(user)).build());
        }
        return new PageImpl((PageRequest)new PageRequestImpl(page.getStart(), page.getLimit(), page.getFilter()), values.size(), values, page.getIsLastPage());
    }
}

