/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.AuthenticationFailedException;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.PasswordResetHelper;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserUtils;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.CaptchaAuthenticationException;
import com.atlassian.stash.user.CaptchaResponse;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.CaptchaServiceException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserService.class)
@Service(value="userService")
@Transactional(readOnly=true)
public class UserServiceImpl
implements UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserServiceImpl.class);
    public static final String FAILED_AUTHENTICATION_ATTEMPT_COUNT = "failedAuthenticationAttemptCount";
    private final DirectoryManager directoryManager;
    private final CrowdService crowdService;
    private final I18nService i18nService;
    private final StashUserDao stashUserDao;
    private final PasswordResetHelper passwordResetHelper;
    private final UserUtils userUtils;
    private final CaptchaService captchaService;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final StashAuthenticationContext authenticationContext;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;
    @Value(value="${page.max.groups}")
    private int maxGroupPageSize;
    private static final Function<String, String> LOWERCASE_STRING = new Function<String, String>(){

        public String apply(String groupName) {
            return IdentifierUtils.toLowerCase((String)groupName);
        }
    };
    private final Predicate<StashUser> notDeletedPredicate = new Predicate<StashUser>(){

        public boolean apply(StashUser user) {
            User crowdUser = UserServiceImpl.this.crowdService.getUser(user.getName());
            return crowdUser != null;
        }
    };

    @Autowired
    public UserServiceImpl(CrowdService crowdService, DirectoryManager directoryManager, I18nService i18nService, StashUserDao stashUserDao, PasswordResetHelper passwordResetHelper, UserUtils userUtils, CaptchaService captchaService, ApplicationPropertiesService applicationPropertiesService, StashAuthenticationContext authenticationContext) {
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.i18nService = i18nService;
        this.stashUserDao = stashUserDao;
        this.passwordResetHelper = passwordResetHelper;
        this.userUtils = userUtils;
        this.captchaService = captchaService;
        this.applicationPropertiesService = applicationPropertiesService;
        this.authenticationContext = authenticationContext;
    }

    @Transactional(noRollbackFor={AuthenticationFailedException.class})
    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser authenticate(@Nonnull String name, @Nonnull String credential, CaptchaResponse captchaResponse) {
        if (this.captchaEntryRequiredByUser(name)) {
            if (captchaResponse == null) {
                throw new CaptchaAuthenticationException(this.missingCaptchaResponse());
            }
            if (!this.isCaptchaValid(captchaResponse)) {
                this.incFailedAuthAttemptCountUser(name);
                throw new CaptchaAuthenticationException(this.invalidCaptcha());
            }
        }
        try {
            User crowdUser = this.crowdService.authenticate(name, credential);
            if (crowdUser == null) {
                throw new com.atlassian.stash.exception.OperationFailedException(this.remoteDirOpFail());
            }
            StashUser stashUser = this.getOrCreateMappedUser(crowdUser);
            this.clearFailedAuthAttemptCountForUser(name);
            return stashUser;
        }
        catch (ExpiredCredentialException e) {
            throw AuthenticationFailedException.captchaNotRequired((KeyedMessage)this.expiredCredentials());
        }
        catch (InactiveAccountException e) {
            throw AuthenticationFailedException.captchaNotRequired((KeyedMessage)this.inactiveAccount());
        }
        catch (OperationFailedException e) {
            throw new com.atlassian.stash.exception.OperationFailedException(this.remoteDirOpFail());
        }
        catch (FailedAuthenticationException e) {
            long numFailedAttempts = this.incFailedAuthAttemptCountUser(name);
            throw this.captchaEntryRequired(numFailedAttempts) ? AuthenticationFailedException.captchaRequired((KeyedMessage)this.authFail()) : AuthenticationFailedException.captchaNotRequired((KeyedMessage)this.authFail());
        }
    }

    private boolean isCaptchaValid(CaptchaResponse captchaResponse) {
        try {
            return this.captchaService.validateResponseForID(captchaResponse.getChallengeId(), (Object)captchaResponse.getUserResponse());
        }
        catch (CaptchaServiceException e) {
            throw new com.atlassian.stash.exception.OperationFailedException(this.captchaServiceFail());
        }
    }

    private boolean captchaEntryRequiredByUser(String userName) {
        return this.captchaEntryRequired(this.getFailedAuthAttemptCountForUser(userName));
    }

    private boolean captchaEntryRequired(long badPasswordCount) {
        return badPasswordCount > 0L && badPasswordCount >= (long)this.applicationPropertiesService.getMaxCaptchaAttempts();
    }

    private KeyedMessage missingCaptchaResponse() {
        return this.i18nService.getKeyedText("stash.service.user.missingcaptcharesponse", "No CAPTCHA response was supplied", new Object[0]);
    }

    private KeyedMessage invalidCaptcha() {
        return this.i18nService.getKeyedText("stash.service.user.invalidcaptcha", "The CAPTCHA was supplied but it was invalid", new Object[0]);
    }

    private KeyedMessage remoteDirOpFail() {
        return this.i18nService.getKeyedText("stash.service.user.opfail", "Authentication failed because the remote user directory did not respond properly", new Object[0]);
    }

    private KeyedMessage captchaServiceFail() {
        return this.i18nService.getKeyedText("stash.service.user.captchasvcfail", "The CAPTCHA service found itself in an awkward situation", new Object[0]);
    }

    private KeyedMessage expiredCredentials() {
        return this.i18nService.getKeyedText("stash.service.user.expiredcredentials", "Authentication failed because the credentials have expired", new Object[0]);
    }

    private KeyedMessage inactiveAccount() {
        return this.i18nService.getKeyedText("stash.service.user.inactive", "Authentication failed because the user account is inactive", new Object[0]);
    }

    private KeyedMessage authFail() {
        return this.i18nService.getKeyedText("stash.service.user.authenticationfailed", "Authentication failed because the user does not exist, or the account is inactive, or the credentials are incorrect", new Object[0]);
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser getUser(@Nonnull Integer id) {
        InternalStashUser user = (InternalStashUser)this.stashUserDao.getById((Object)id);
        if (user == null) {
            LOG.warn("User with ID " + id + " does not exist");
            return null;
        }
        User crowdUser = this.crowdService.getUser(user.getName());
        return this.getOrCreateMappedUser(user, crowdUser);
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser getUser(@Nonnull String name) {
        return this.getUser(name, false);
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser getUser(@Nonnull String name, boolean returnDeletedUsers) {
        StashUser user = null;
        User crowdUser = this.crowdService.getUser(name);
        if (crowdUser != null) {
            user = this.getOrCreateMappedUser(crowdUser);
        } else if (returnDeletedUsers) {
            user = this.stashUserDao.findByName(name);
        }
        return user;
    }

    @Transactional
    @Secured(value="You can only update the profile of the current user")
    public StashUser updateProfile(@Nonnull String displayName, @Nonnull String email) {
        String name = this.getCurrentUser().getName();
        User update = ImmutableUser.newUser().name(name).displayName(displayName).emailAddress(email).toUser();
        try {
            this.crowdService.updateUser(update);
        }
        catch (InvalidUserException e) {
            throw this.canNotUpdateProfile((Exception)((Object)e));
        }
        catch (OperationNotPermittedException e) {
            throw this.canNotUpdateProfile((Exception)((Object)e));
        }
        catch (OperationFailedException e) {
            throw this.canNotUpdateProfile((Exception)((Object)e));
        }
        return this.getUser(name);
    }

    @Transactional
    @Secured(value="You can only update the profile of the current user")
    public void updatePassword(@Nonnull String oldPassword, @Nonnull String newPassword) {
        String name = this.getCurrentUser().getName();
        try {
            User user = this.crowdService.authenticate(name, oldPassword);
            this.passwordResetHelper.resetPassword(user, newPassword);
        }
        catch (FailedAuthenticationException e) {
            throw AuthenticationFailedException.captchaNotRequired((KeyedMessage)this.i18nService.getKeyedText("stash.service.user.password.invalid", "The current password does not match", new Object[0]));
        }
        catch (InvalidCredentialException e) {
            throw this.canNotUpdateUserPassword(name, (Exception)((Object)e));
        }
        catch (OperationNotPermittedException e) {
            throw this.canNotUpdateUserPassword(name, (Exception)((Object)e));
        }
        catch (OperationFailedException e) {
            throw this.canNotUpdateUserPassword(name, (Exception)((Object)e));
        }
    }

    @Nonnull
    private StashUser getCurrentUser() {
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.getKeyedText("stash.service.user.canNotUpdate.anonymous", "Please login to update your profile or password", new Object[0]));
        }
        return user;
    }

    private ServerException canNotUpdateProfile(Exception e) {
        KeyedMessage keyedText = this.i18nService.getKeyedText("stash.service.user.profile.canNotUpdate", "Could not update your profile: {0}", new Object[]{Throwables.getRootCause((Throwable)e).getLocalizedMessage()});
        if (LOG.isDebugEnabled()) {
            LOG.debug(keyedText.getLocalisedMessage(), (Throwable)e);
        }
        throw new ServerException(keyedText, (Throwable)e);
    }

    private ServerException canNotUpdateUserPassword(String name, Exception e) {
        Preconditions.checkNotNull((Object)name);
        KeyedMessage keyedText = this.i18nService.getKeyedText("stash.service.user.password.canNotUpdate", "Could not update your password: {0}", new Object[]{Throwables.getRootCause((Throwable)e).getLocalizedMessage()});
        if (LOG.isDebugEnabled()) {
            LOG.debug(keyedText.getLocalisedMessage(), (Throwable)e);
        }
        throw new ServerException(keyedText, (Throwable)e);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<? extends StashUser> findAllUsers(@Nonnull PageRequest pageRequest) {
        return this.findAllUsers(false, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<? extends StashUser> findAllUsers(boolean includeDeletedUsers, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        Predicate<StashUser> includePredicate = Predicates.alwaysTrue();
        if (!includeDeletedUsers) {
            includePredicate = this.notDeletedPredicate;
        }
        Page page = this.stashUserDao.findAll(pageRequest, includePredicate);
        return this.userUtils.getCrowdBackedPage((Page<? extends StashUser>)page);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<? extends StashUser> findUsersByContainedText(String containedText, @Nonnull PageRequest pageRequest) {
        return this.findUsersByContainedText(containedText, false, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<? extends StashUser> findUsersByContainedText(String containedText, boolean includeDeletedUsers, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        Predicate<StashUser> includePredicate = Predicates.alwaysTrue();
        if (!includeDeletedUsers) {
            includePredicate = this.notDeletedPredicate;
        }
        Page page = this.stashUserDao.findAllByContainedText(containedText, pageRequest, includePredicate);
        return this.userUtils.getCrowdBackedPage((Page<? extends StashUser>)page);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<String> findAllGroups(@Nonnull PageRequest pageRequest) {
        return this.findGroupsByContainedText(null, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<String> findGroupsByContainedText(String containedText, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        Iterable<Group> groups = this.search((Class)Group.class, EntityDescriptor.group(), pageRequest.getStart(), pageRequest.getLimit() + 1, (SearchRestriction)(StringUtils.isNotBlank((String)containedText) ? Restriction.on((Property)GroupTermKeys.NAME).containing((Object)containedText) : null));
        Iterable groupNames = Iterables.transform(groups, (Function)new Function<Group, String>(){

            public String apply(@Nullable Group group) {
                return group == null ? null : group.getName();
            }
        });
        int size = Iterables.size((Iterable)groupNames);
        return new PageImpl(pageRequest, Math.min(size, pageRequest.getLimit()), Iterables.limit((Iterable)groupNames, (int)pageRequest.getLimit()), size <= pageRequest.getLimit());
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN') or isCurrentUser(#user.name)")
    public boolean isUserMemberOfGroup(@Nonnull StashUser user, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)groupName);
        InternalStashUser internalUser = InternalConverter.convertToInternalUser(user);
        User crowdUser = this.userUtils.getBackingCrowdUser((StashUser)internalUser);
        try {
            return this.directoryManager.isUserNestedGroupMember(crowdUser.getDirectoryId(), crowdUser.getName(), groupName);
        }
        catch (DirectoryNotFoundException e) {
            LOG.error("User directory was not found", (Throwable)e);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            LOG.error("Could not determine group membership for user " + user.getName(), (Throwable)e);
        }
        return false;
    }

    @Nonnull
    @Unsecured(value="This isn't restricted by permission because its needed by everyone via licencing, permissioning and login")
    public Page<String> getGroupsForUser(@Nonnull String username, @Nonnull PageRequest pageRequest) {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(pageRequest.getStart()).returningAtMost(pageRequest.getLimit() + 1);
        Iterable results = this.crowdService.search((Query)query);
        Iterable lowerCaseResults = Iterables.transform((Iterable)results, LOWERCASE_STRING);
        return PageUtils.createPage((Iterable)lowerCaseResults, (PageRequest)pageRequest);
    }

    @Nonnull
    @Unsecured(value="This isn't restricted by permission because its needed by everyone via licencing, permissioning and login")
    public Page<String> getUsersInGroup(@Nonnull String groupName, @Nonnull PageRequest pageRequest) {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(pageRequest.getStart()).returningAtMost(pageRequest.getLimit() + 1);
        Iterable userNames = this.crowdService.search((Query)query);
        return PageUtils.createPage((Iterable)userNames, (PageRequest)pageRequest);
    }

    long getFailedAuthAttemptCountForUser(@Nonnull String username) {
        Preconditions.checkNotNull((Object)username);
        UserWithAttributes user = this.crowdService.getUserWithAttributes(username);
        if (user != null) {
            Long attempts = this.getFailedAuthAttemptCountForUser(user);
            return attempts == null ? 0L : attempts;
        }
        return 0L;
    }

    private Long getFailedAuthAttemptCountForUser(UserWithAttributes user) {
        String attemptsAsString = user.getValue(FAILED_AUTHENTICATION_ATTEMPT_COUNT);
        if (attemptsAsString != null) {
            try {
                return Long.valueOf(attemptsAsString);
            }
            catch (NumberFormatException e) {
                LOG.error(String.format("Invalid attribute %s for user %s: %s", FAILED_AUTHENTICATION_ATTEMPT_COUNT, user.getName(), attemptsAsString));
            }
        }
        return 0L;
    }

    @Transactional
    long incFailedAuthAttemptCountUser(@Nonnull String username) {
        Preconditions.checkNotNull((Object)username);
        UserWithAttributes user = this.crowdService.getUserWithAttributes(username);
        if (user != null) {
            Long failedLoginCount = this.incWithOverflowCheck(this.getFailedAuthAttemptCountForUser(user));
            try {
                this.crowdService.setUserAttribute((User)user, FAILED_AUTHENTICATION_ATTEMPT_COUNT, Long.toString(failedLoginCount));
            }
            catch (OperationNotPermittedException e) {
                this.logAttributeUpdateFailure((Exception)((Object)e));
            }
            return failedLoginCount;
        }
        return 0L;
    }

    @Transactional
    void clearFailedAuthAttemptCountForUser(@Nonnull String username) {
        Preconditions.checkNotNull((Object)username);
        UserWithAttributes user = this.crowdService.getUserWithAttributes(username);
        if (user != null) {
            try {
                this.crowdService.setUserAttribute((User)user, FAILED_AUTHENTICATION_ATTEMPT_COUNT, Long.toString(0L));
            }
            catch (OperationNotPermittedException e) {
                this.logAttributeUpdateFailure((Exception)((Object)e));
            }
        }
    }

    private void logAttributeUpdateFailure(Exception e) {
        String msg = String.format("Couldn't update the %s attribute", FAILED_AUTHENTICATION_ATTEMPT_COUNT);
        LOG.error(msg);
        LOG.debug(msg, (Throwable)e);
    }

    private long incWithOverflowCheck(long val) {
        return val == Long.MAX_VALUE ? Long.MAX_VALUE : val + 1L;
    }

    @Unsecured(value="This is not restricted by permissions so that SAL tests pass. It should not be exposed via rest")
    public boolean isUserMemberOfGroup(@Nonnull String username, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)groupName);
        StashUser user = this.getUser(username);
        return user != null && this.isUserMemberOfGroup(user, groupName);
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public boolean existsGroup(String groupName) {
        return this.crowdService.getGroup(groupName) != null;
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser preauthenticate(@Nonnull String username) {
        StashUser user = this.getUser(username);
        if (user != null) {
            StashUserAuthenticationToken auth = new StashUserAuthenticationToken(user);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        return user;
    }

    @Unsecured(value="This needs to be available to all contexts")
    public void unauthenticate() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private StashUser getOrCreateMappedUser(User crowdUser) {
        Preconditions.checkNotNull((Object)crowdUser);
        InternalStashUser stashUser = this.stashUserDao.findByName(crowdUser.getName());
        return this.getOrCreateMappedUser(stashUser, crowdUser);
    }

    private StashUser getOrCreateMappedUser(InternalStashUser stashUser, User crowdUser) {
        if (crowdUser == null) {
            return null;
        }
        if (stashUser == null) {
            stashUser = new InternalStashUser(crowdUser.getName());
            this.stashUserDao.create((Object)stashUser);
        }
        return stashUser.copy().crowdUser(crowdUser).build();
    }

    private <T> Iterable<T> search(Class<T> entityClass, EntityDescriptor entityDescriptor, int start, int numberToFetch, SearchRestriction restriction) {
        QueryBuilder.PartialEntityQuery builder = QueryBuilder.queryFor(entityClass, (EntityDescriptor)entityDescriptor);
        EntityQuery query = restriction != null ? builder.with(restriction).startingAt(start).returningAtMost(numberToFetch) : builder.startingAt(start).returningAtMost(numberToFetch);
        return this.crowdService.search((Query)query);
    }
}

