/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class RememberMeAuthenticationProviderImpl
extends RememberMeAuthenticationProvider {
    private final UserService userService;
    private final I18nService i18nService;
    private final LicenseService licenseService;

    public RememberMeAuthenticationProviderImpl(String key, UserService userService, I18nService i18nService, LicenseService licenseService) {
        super(key);
        this.userService = userService;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication token = super.authenticate(authentication);
        if (token != null) {
            StashUser user = this.userService.getUser(token.getName());
            if (user == null || !user.isActive()) {
                throw new AccountExpiredException(this.i18nService.getText("stash.user.inactive", "User '{0}' is not an active user", new Object[]{token.getName()}));
            }
            if (!this.licenseService.isUserLicensed(user)) {
                throw new DisabledException("User does not have permission to access this system");
            }
            token = new StashUserAuthenticationToken(user);
        }
        return token;
    }
}

