/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="permissionService")
@AvailableToPlugins(value=PermissionService.class)
@Transactional(readOnly=true)
public class PermissionServiceImpl
implements PermissionService {
    public static final int GROUP_PAGESIZE = 1000;
    public static final int USER_PAGESIZE = 2000;
    private static final Logger LOG = LoggerFactory.getLogger(PermissionServiceImpl.class);
    private static final Predicate<Permission> GRANTABLE_TO_ANONYMOUS = new Predicate<Permission>(){

        public boolean apply(Permission permission) {
            return permission.isGrantableToAnonymous();
        }
    };
    public static final String GROUP_PERMISSION_SEARCH = "Group Permission Search";
    public static final int USER_GROUP_PAGE_LIMIT = 1000;
    private final StashAuthenticationContext authenticationContext;
    private final GrantedPermissionDao grantedPermissionDao;
    private final RepositoryDao repositoryDao;
    private final UserService userService;

    @Autowired
    public PermissionServiceImpl(GrantedPermissionDao grantedPermissionDao, UserService userService, StashAuthenticationContext authenticationContext, RepositoryDao repositoryDao) {
        this.authenticationContext = authenticationContext;
        this.grantedPermissionDao = grantedPermissionDao;
        this.repositoryDao = repositoryDao;
        this.userService = userService;
    }

    public boolean hasGlobalPermission(@Nullable String userName, @Nonnull Permission permission) {
        StashUser user = userName == null ? null : this.userService.getUser(userName);
        return this.hasGlobalPermission(user, permission);
    }

    public boolean hasGlobalPermission(@Nullable StashUser user, @Nonnull Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.hasPermission(user, null, permission);
    }

    public boolean hasGlobalPermission(@Nonnull Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.hasGlobalPermission(this.authenticationContext.getCurrentUser(), permission);
    }

    public boolean hasAnyUserPermission(@Nonnull StashUser user, @Nonnull Permission permission) {
        return this.hasPermission(user, -1, permission);
    }

    public boolean hasAnyUserPermission(@Nonnull Permission permission) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && this.hasAnyUserPermission(currentUser, permission);
    }

    public boolean hasProjectPermission(@Nullable StashUser user, @Nonnull Project project, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(user, project.getId(), permission);
    }

    public boolean hasProjectPermission(@Nonnull Project project, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasProjectPermission(this.authenticationContext.getCurrentUser(), project, permission);
    }

    public boolean hasProjectPermission(@Nonnull Integer projectId, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(this.authenticationContext.getCurrentUser(), projectId, permission);
    }

    public boolean hasProjectPermission(@Nullable StashUser user, @Nonnull Integer projectId, @Nonnull Permission requestedPermission) {
        Preconditions.checkArgument((!requestedPermission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(user, projectId, requestedPermission);
    }

    private boolean hasPermission(StashUser user, Integer projectId, Permission requestedPermission) {
        Set inheritingPermissions = requestedPermission.getInheritingPermissions();
        if (LOG.isTraceEnabled()) {
            LOG.trace("user = " + user);
            LOG.trace("projectId = " + projectId);
            LOG.trace("requested permission = " + requestedPermission);
        }
        if (user instanceof StashUserAuthenticationToken) {
            StashUserAuthenticationToken token = (StashUserAuthenticationToken)user;
            for (Permission runWithPermission : token.getRunWithPermissions()) {
                if (!inheritingPermissions.contains(runWithPermission)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("permission granted by elevated permissions (from %s)", StashAuthenticationContext.class.getSimpleName()));
                }
                return true;
            }
            if (token.getPrincipal() == null) {
                return false;
            }
        }
        if (user != null) {
            return this.hasDirectUserPermission(user, projectId, inheritingPermissions) || this.hasPermissionsThroughGroup(user, projectId, inheritingPermissions, Collections.<String>emptySet());
        }
        if (Iterables.any((Iterable)inheritingPermissions, GRANTABLE_TO_ANONYMOUS)) {
            return this.grantedPermissionDao.isGrantedForAnonByProject(inheritingPermissions, projectId);
        }
        return false;
    }

    public boolean hasDirectGlobalUserPermission(Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentUser(), null, inheritingPermissions);
    }

    public boolean hasDirectProjectUserPermission(Project project, Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentUser(), project.getId(), inheritingPermissions);
    }

    private boolean hasDirectUserPermission(StashUser user, Integer projectId, Set<Permission> inheritingPermissions) {
        boolean hasDirectUserPermission = this.grantedPermissionDao.isGrantedByProjectAndUser(inheritingPermissions, projectId, user.getId());
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("permission (or an inheritor) %s explicitly granted to user", hasDirectUserPermission ? "IS" : "IS NOT"));
        }
        return hasDirectUserPermission;
    }

    public boolean hasGlobalGroupPermission(Permission permission, String group) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.grantedPermissionDao.isGrantedByProjectAndGroup(inheritingPermissions, null, group);
    }

    public Page<StashUser> getGrantedUsers(Permission permission, PageRequest request) {
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.grantedPermissionDao.getGrantedUsers(inheritingPermissions, request);
    }

    public Page<String> getGrantedGroups(Permission permission, PageRequest request) {
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.grantedPermissionDao.getGrantedGroups(inheritingPermissions, request);
    }

    public boolean hasGlobalPermissionThroughGroupMembership(Permission permission, Set<String> excludedGroups) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.hasPermissionsThroughGroup(this.authenticationContext.getCurrentUser(), null, inheritingPermissions, excludedGroups);
    }

    public boolean hasProjectPermissionThroughGroupMembership(Project project, Permission permission, Set<String> excludedGroups) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        Set inheritingPermissions = permission.getInheritingPermissions();
        return this.hasPermissionsThroughGroup(this.authenticationContext.getCurrentUser(), project.getId(), inheritingPermissions, excludedGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPermissionsThroughGroup(StashUser user, Integer projectId, Set<Permission> inheritingPermissions, Set<String> excludedGroups) {
        UtilTimerStack.push((String)GROUP_PERMISSION_SEARCH);
        try {
            Page groupPage;
            HashSet usersGroups = null;
            PageRequestImpl userGroupStartPageRequest = new PageRequestImpl(0, 1000);
            Page usersGroupsPage = this.userService.getGroupsForUser(user.getName(), (PageRequest)userGroupStartPageRequest);
            if (usersGroupsPage.getIsLastPage()) {
                usersGroups = new HashSet();
                Iterables.addAll(usersGroups, (Iterable)usersGroupsPage.getValues());
                Iterables.removeAll(usersGroups, excludedGroups);
                if (usersGroups.isEmpty()) {
                    LOG.trace("no groups checked for permission (user may not belong to any groups or groups may have all been excluded)");
                    boolean bl = false;
                    return bl;
                }
                if (usersGroups.size() == 1) {
                    String group = (String)usersGroups.iterator().next();
                    boolean grantedByProjectAndGroup = this.grantedPermissionDao.isGrantedByProjectAndGroup(inheritingPermissions, projectId, group);
                    if (grantedByProjectAndGroup && LOG.isTraceEnabled()) {
                        LOG.trace(String.format("permission granted by membership of '%s'", group));
                    }
                    boolean bl = grantedByProjectAndGroup;
                    return bl;
                }
            }
            int offset = 0;
            do {
                groupPage = this.grantedPermissionDao.getGrantedGroupsByPermissionAndProject(inheritingPermissions, projectId, (PageRequest)new PageRequestImpl(offset, 1000));
                if (usersGroups != null) {
                    for (String group : groupPage.getValues()) {
                        if (!usersGroups.contains(group)) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(String.format("permission granted by membership of '%s'", group));
                        }
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    if (usersGroupsPage.getIsLastPage()) {
                        usersGroupsPage = this.userService.getGroupsForUser(user.getName(), (PageRequest)userGroupStartPageRequest);
                    }
                    while (true) {
                        HashSet pageOfGroups = new HashSet();
                        Iterables.addAll(pageOfGroups, (Iterable)usersGroupsPage.getValues());
                        Iterables.removeAll(pageOfGroups, excludedGroups);
                        for (String group : groupPage.getValues()) {
                            if (!pageOfGroups.contains(group)) continue;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace(String.format("permission granted by membership of '%s'", group));
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (usersGroupsPage.getIsLastPage()) break;
                        usersGroupsPage = this.userService.getGroupsForUser(user.getName(), usersGroupsPage.getNextPageRequest());
                    }
                }
                offset += 1000;
            } while (!groupPage.getIsLastPage());
            LOG.trace("permission not granted by any group membership");
            boolean bl = false;
            return bl;
        }
        finally {
            UtilTimerStack.pop((String)GROUP_PERMISSION_SEARCH);
        }
    }

    public boolean hasRepositoryPermission(@Nullable StashUser user, @Nonnull Repository repository, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(user, repository.getProject().getId(), permission);
    }

    public boolean hasRepositoryPermission(@Nullable StashUser user, @Nonnull Integer repoId, @Nonnull Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repoId);
        return this.hasRepositoryPermission(user, repository, permission);
    }

    public boolean hasRepositoryPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentUser(), repository, permission);
    }

    public boolean hasRepositoryPermission(@Nonnull Integer repositoryId, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentUser(), repositoryId, permission);
    }

    public Set<String> getUsersWithPermission(Permission permission) {
        Page<String> groups;
        Page<StashUser> users;
        HashSet<String> usersWithPermission = new HashSet<String>();
        PageRequestImpl request = new PageRequestImpl(0, 2000);
        do {
            users = this.getGrantedUsers(permission, (PageRequest)request);
            for (StashUser user : users.getValues()) {
                usersWithPermission.add(IdentifierUtils.toLowerCase((String)user.getName()));
            }
        } while ((request = users.getNextPageRequest()) != null);
        request = new PageRequestImpl(0, 1000);
        do {
            groups = this.getGrantedGroups(permission, (PageRequest)request);
            for (String group : groups.getValues()) {
                Page users2 = this.userService.getUsersInGroup(group, (PageRequest)request);
                for (String username : users2.getValues()) {
                    usersWithPermission.add(IdentifierUtils.toLowerCase((String)username));
                }
            }
        } while ((request = groups.getNextPageRequest()) != null);
        return usersWithPermission;
    }

    public int getCountOfUsersWithPermission(Permission permission) {
        return this.getUsersWithPermission(permission).size();
    }

    public Permission getHighestGlobalPermission(@Nullable StashUser user) {
        if (user == null) {
            return null;
        }
        ArrayList globalPermissions = Lists.newArrayList((Iterable)Permission.getGlobalPermissions());
        Collections.sort(globalPermissions, new Comparator<Permission>(){

            @Override
            public int compare(Permission o1, Permission o2) {
                return o1 == o2 ? 0 : (o1.getInheritedPermissions().contains(o2) ? -1 : 1);
            }
        });
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalPermission(user, globalPermission)) continue;
            return globalPermission;
        }
        return null;
    }

    public Permission getHighestGlobalPermission(@Nullable String userName) {
        StashUser user = userName != null ? this.userService.getUser(userName) : null;
        return user != null ? this.getHighestGlobalPermission(user) : null;
    }
}

