/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class GroupsWithoutPermissionFilter
extends PageFilter<String> {
    private Set<String> groupsWithPermission;

    public SortedMap<Integer, String> apply(int limit, Page<? extends String> page) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        HashMap groupsWithPermissionMap = new HashMap();
        for (Map.Entry entry : page.getOrdinalIndexedValues().entrySet()) {
            groupsWithPermissionMap.put(entry.getValue(), entry.getKey());
        }
        if (this.groupsWithPermission != null) {
            groupsWithPermissionMap.keySet().removeAll(this.groupsWithPermission);
        } else {
            Page<String> groupsWithPermPage = this.getGroupsWithPermission((PageRequest)new PageRequestImpl(0, 500));
            if (groupsWithPermPage.getIsLastPage()) {
                this.groupsWithPermission = new HashSet<String>();
                Iterables.addAll(this.groupsWithPermission, (Iterable)groupsWithPermPage.getValues());
                groupsWithPermissionMap.keySet().removeAll(this.groupsWithPermission);
            } else {
                while (true) {
                    for (String group : groupsWithPermPage.getValues()) {
                        groupsWithPermissionMap.remove(group);
                        if (!groupsWithPermissionMap.isEmpty()) continue;
                        break;
                    }
                    if (groupsWithPermissionMap.isEmpty() || groupsWithPermPage.getIsLastPage()) break;
                    groupsWithPermPage = this.getGroupsWithPermission(groupsWithPermPage.getNextPageRequest());
                }
            }
        }
        TreeMap<Integer, String> results = new TreeMap<Integer, String>();
        for (Map.Entry entry : groupsWithPermissionMap.entrySet()) {
            results.put((Integer)entry.getValue(), (String)entry.getKey());
        }
        return results;
    }

    protected abstract Page<String> getGroupsWithPermission(PageRequest var1);
}

