/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.Product;
import com.atlassian.stash.server.ApplicationPropertiesService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationInfoLogger {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInfoLogger.class);
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public ApplicationInfoLogger(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @PostConstruct
    public void onConstruct() {
        log.info("Starting " + Product.NAME + " " + this.propertiesService.getBuildVersion() + " (" + StringUtils.substring((String)this.propertiesService.getCommitHash(), (int)0, (int)10) + " built on " + this.propertiesService.getBuildTimestamp() + ")");
        log.info("JVM: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version"));
    }

    @PreDestroy
    public void onDestroy() {
        log.info("Shutting down " + Product.NAME + " " + this.propertiesService.getBuildVersion());
    }
}

