/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.stash.exception.ScmClientException;
import com.atlassian.stash.exception.UnsupportedScmTypeException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.repository.ScmType;
import com.atlassian.stash.scm.ScmClient;
import com.atlassian.stash.scm.ScmClientModuleDescriptor;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScmClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScmClientProvider.class);
    private static final String STARS = StringUtils.repeat((String)"*", (int)75);
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PluginModuleTracker<ScmClient, ScmClientModuleDescriptor> pluginModuleTracker;

    @Autowired
    public ScmClientProvider(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, I18nService i18nService, EventPublisher eventPublisher) {
        this.i18nService = i18nService;
        this.eventPublisher = eventPublisher;
        this.pluginModuleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, ScmClientModuleDescriptor.class);
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.pluginModuleTracker.close();
    }

    public ScmClient get(ScmType scmType) {
        for (ScmClient client : this.pluginModuleTracker.getModules()) {
            if (!client.getScmType().equals((Object)scmType)) continue;
            ScmClient.Status status = client.getStatus();
            if (!status.isAvailable()) {
                throw new ScmClientException(status.getMessage());
            }
            return client;
        }
        throw new UnsupportedScmTypeException(this.getUnsupportedScmTypeMessage(scmType));
    }

    public KeyedMessage getUnsupportedScmTypeMessage(ScmType type) {
        return this.i18nService.getKeyedText("stash.scm.unsupported", "{0} is not a supported SCM", new Object[]{type.getFullName()});
    }

    public boolean isSupported(ScmType scmType) {
        for (ScmClient client : this.pluginModuleTracker.getModules()) {
            if (!client.getScmType().equals((Object)scmType)) continue;
            return true;
        }
        return false;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        try {
            ScmClient client = this.get(ScmType.GIT);
            KeyedMessage statusMessage = client.getStatus().getMessage();
            if (statusMessage != null) {
                LOG.info(statusMessage.getRootMessage());
            }
        }
        catch (ScmClientException e) {
            String localisedMessage = e.getLocalizedMessage();
            LOG.error(STARS);
            LOG.error(localisedMessage);
            LOG.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), localisedMessage, EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
        catch (UnsupportedScmTypeException e) {
            LOG.error(e.getLocalizedMessage());
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), this.i18nService.getText("stash.plugin.failed", "Plugin {0} has failed", new Object[]{"Git SCM Plugin"}), EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
    }
}

