/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.scm.ScmClientProvider;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefOrder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.Tag;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=RepositoryMetadataService.class)
@PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
@Service(value="repositoryMetadataService")
public class RepositoryMetadataServiceImpl
extends AbstractScmService
implements RepositoryMetadataService {
    @Value(value="${page.max.branches}")
    private int maxBranches;
    @Value(value="${page.max.tags}")
    private int maxTags;

    @Autowired
    public RepositoryMetadataServiceImpl(ScmClientProvider clientProvider) {
        super(clientProvider);
    }

    @Nonnull
    public Page<? extends Branch> getBranches(@Nonnull Repository repository, @Nonnull PageRequest pageRequest, @Nullable String filterText, @Nullable RefOrder order) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxBranches);
        Page page = (Page)this.getScmClient(repository).getBranchesCommand(repository, pageRequest, filterText, order).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    @Nonnull
    public Branch getDefaultBranch(@Nonnull Repository repository) {
        return (Branch)this.getScmClient(repository).getDefaultBranchCommand(repository).call();
    }

    @Nonnull
    public Page<? extends Tag> getTags(@Nonnull Repository repository, @Nonnull PageRequest pageRequest, @Nullable String filterText, @Nullable RefOrder order) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxTags);
        Page page = (Page)this.getScmClient(repository).getTagsCommand(repository, pageRequest, filterText, order).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    public boolean isEmpty(@Nonnull Repository repository) {
        return this.getScmClient(repository).isEmpty(repository);
    }

    @Nullable
    public Ref resolveRef(@Nonnull Repository repository, @Nullable String objectId) {
        if (objectId == null) {
            return this.getDefaultBranch(repository);
        }
        return (Ref)this.getScmClient(repository).getResolveRefCommand(repository, objectId).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void setDefaultBranch(@Nonnull Repository repository, @Nonnull String branchName) {
        this.getScmClient(repository).getSetDefaultBranchCommand(repository, branchName).call();
    }
}

