/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.RepositoryPushEvent;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.idx.ChangesetIndexingService;
import com.atlassian.stash.internal.idx.impl.ChangesetIndexingJob;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ChangesetIndexingScheduler {
    private static final Logger log = LoggerFactory.getLogger(ChangesetIndexingScheduler.class);
    private final ChangesetIndexingService indexingService;
    private final ThreadPoolExecutor threadPool;
    private final BlockingQueue<Runnable> indexingQueue;

    @Autowired
    public ChangesetIndexingScheduler(@Value(value="${indexing.job.queue.size}") int maxQueueSize, @Value(value="${indexing.max.threads}") int maxIndexingThreads, ChangesetIndexingService indexingService, StatefulService[] services) {
        this.indexingQueue = new LinkedBlockingQueue<Runnable>(maxQueueSize);
        this.indexingService = indexingService;
        log.info("Starting changeset indexing threadpool with a maximum of " + maxIndexingThreads + " threads.");
        this.threadPool = new NoDuplicatesThreadPoolExecutor(maxIndexingThreads, maxIndexingThreads, 2L, TimeUnit.MINUTES, (BlockingQueue)this.indexingQueue);
    }

    @PreDestroy
    public void shutdown() {
        this.threadPool.shutdown();
    }

    public void setMaxIndexingThreads(int max) {
        this.threadPool.setMaximumPoolSize(max);
    }

    @EventListener
    public synchronized void onPushEvent(RepositoryPushEvent event) {
        ChangesetIndexingJob indexingJob = new ChangesetIndexingJob(event.getRepository(), this.indexingService);
        try {
            this.threadPool.submit(indexingJob);
        }
        catch (RejectedExecutionException e) {
            log.debug("Indexing request for repository " + event.getRepository().getSlug() + "rejected; " + StringUtils.defaultString((String)e.getMessage(), (String)"Indexing queue is full"));
        }
    }

    public int getQueueSize() {
        return this.indexingQueue.size();
    }

    private static class NoDuplicatesThreadPoolExecutor
    extends ThreadPoolExecutor {
        private Map<RunnableFuture<?>, Runnable> runnables = Collections.synchronizedMap(new HashMap());

        private NoDuplicatesThreadPoolExecutor(int i, int i1, long l, TimeUnit timeUnit, BlockingQueue<Runnable> runnables) {
            super(i, i1, l, timeUnit, runnables);
        }

        private void rejectIfPresent(Runnable runnable) {
            if (this.runnables.values().contains(runnable)) {
                throw new RejectedExecutionException("Runnable " + runnable.toString() + " already queued");
            }
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            this.rejectIfPresent(runnable);
            return super.submit(runnable);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            RunnableFuture<T> result = super.newTaskFor(runnable, t);
            this.runnables.put(result, runnable);
            return result;
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            super.beforeExecute(thread, runnable);
            this.runnables.remove(runnable);
        }
    }
}

